<!DOCTYPE html>
<html>
<head>
    <title>Laporan Kinerja Teknisi</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 16px;
        }
        .header p {
            margin: 3px 0;
            font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table th {
            background-color: #2196F3;
            color: white;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        table td {
            border: 1px solid #ddd;
            padding: 6px;
            font-size: 10px;
        }
        table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        h3 {
            margin-top: 20px;
            font-size: 14px;
        }
        .summary-box {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        .summary-box p {
            margin: 5px 0;
            font-size: 10px;
            padding: 3px 5px;
        }
        .summary-box p.header {
            font-weight: bold;
            font-size: 11px;
            background-color: #e0e0e0;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN KINERJA TEKNISI</h2>
        <p>Periode: <?php echo e(Carbon\Carbon::parse($startDate)->format('d/m/Y')); ?> - <?php echo e(Carbon\Carbon::parse($endDate)->format('d/m/Y')); ?></p>
        <p>Teknisi: <?php echo e($technicianName); ?> | Cabang: <?php echo e($branchName); ?></p>
    </div>

    <div class="summary-box">
        <p class="header">Ringkasan</p>
        <p>Total Service: <?php echo e($services->count()); ?></p>
        <p>Selesai: <?php echo e($services->where('status', 'selesai')->count()); ?></p>
        <p>Jumlah Teknisi: <?php echo e($technicianStats->count()); ?></p>
        <p>Total Pendapatan: Rp <?php echo e(number_format($services->where('status', 'selesai')->sum('total_cost') / 1000, 0)); ?>K</p>
    </div>

    <h3>Statistik Per Teknisi</h3>
    <table>
        <thead>
            <tr>
                <th>Teknisi</th>
                <th class="text-center">Total</th>
                <th class="text-center">Selesai</th>
                <th class="text-center">Proses</th>
                <th class="text-center">Batal</th>
                <th class="text-center">Success Rate</th>
                <th class="text-center">Avg Durasi</th>
                <th class="text-right">Pendapatan</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $technicianStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><strong><?php echo e($stat['technician_name']); ?></strong></td>
                <td class="text-center"><?php echo e($stat['total_services']); ?></td>
                <td class="text-center"><?php echo e($stat['completed']); ?></td>
                <td class="text-center"><?php echo e($stat['in_progress']); ?></td>
                <td class="text-center"><?php echo e($stat['cancelled']); ?></td>
                <td class="text-center"><?php echo e($stat['success_rate']); ?>%</td>
                <td class="text-center"><?php echo e($stat['avg_duration_days']); ?> hari</td>
                <td class="text-right">Rp <?php echo e(number_format($stat['total_revenue'], 0, ',', '.')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr style="font-weight: bold;">
                <td>TOTAL</td>
                <td class="text-center"><?php echo e($technicianStats->sum('total_services')); ?></td>
                <td class="text-center"><?php echo e($technicianStats->sum('completed')); ?></td>
                <td class="text-center"><?php echo e($technicianStats->sum('in_progress')); ?></td>
                <td class="text-center"><?php echo e($technicianStats->sum('cancelled')); ?></td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-right">Rp <?php echo e(number_format($technicianStats->sum('total_revenue'), 0, ',', '.')); ?></td>
            </tr>
        </tfoot>
    </table>

    <h3>Detail Service</h3>
    <table>
        <thead>
            <tr>
                <th>No. Service</th>
                <th>Tanggal</th>
                <th>Customer</th>
                <th>Device</th>
                <th>Teknisi</th>
                <th>Status</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($service->service_number); ?></td>
                <td><?php echo e($service->service_date->format('d/m/Y')); ?></td>
                <td><?php echo e($service->customer->name); ?></td>
                <td><?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?></td>
                <td><?php echo e($service->technician->name ?? '-'); ?></td>
                <td><?php echo e(ucwords($service->status)); ?></td>
                <td class="text-right">Rp <?php echo e(number_format($service->total_cost, 0, ',', '.')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div style="margin-top: 30px; font-size: 9px; color: #666;">
        <p>Dicetak pada: <?php echo e(now()->format('d/m/Y H:i:s')); ?></p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/service/pdf/technician.blade.php ENDPATH**/ ?>