<?php $__env->startSection('heading', 'Laporan Kinerja Teknisi'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Laporan Kinerja Teknisi</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Laporan Service - Teknisi</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Filter Form -->
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Filter Laporan</h3>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('report.service.technician')); ?>" method="GET">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Mulai</label>
                                <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Akhir</label>
                                <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Teknisi</label>
                                <select name="technician_id" class="form-control">
                                    <option value="">Semua Teknisi</option>
                                    <?php $__currentLoopData = $technicians; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tech): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tech->id); ?>" <?php echo e($technicianId == $tech->id ? 'selected' : ''); ?>>
                                        <?php echo e($tech->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Cabang</label>
                                <select name="branch_id" class="form-control">
                                    <option value="">Semua Cabang</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($branch->id); ?>" <?php echo e($branchId == $branch->id ? 'selected' : ''); ?>>
                                        <?php echo e($branch->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Tampilkan
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('report.service.technician.export-pdf', ['start_date' => $startDate, 'end_date' => $endDate, 'technician_id' => $technicianId, 'branch_id' => $branchId])); ?>" class="btn btn-danger" target="_blank">
                            <i class="fas fa-file-pdf"></i> Export PDF
                        </a>
                        <a href="<?php echo e(route('report.service.technician.export-excel', ['start_date' => $startDate, 'end_date' => $endDate, 'technician_id' => $technicianId, 'branch_id' => $branchId])); ?>" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> Export Excel
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3><?php echo e($services->count()); ?></h3>
                        <p>Total Service</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-wrench"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3><?php echo e($services->where('status', 'selesai')->count()); ?></h3>
                        <p>Selesai</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3><?php echo e($technicianStats->count()); ?></h3>
                        <p>Jumlah Teknisi</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3>Rp <?php echo e(number_format($services->where('status', 'selesai')->sum('total_cost') / 1000, 0)); ?>K</h3>
                        <p>Total Pendapatan</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart -->
        <div class="card">
            <div class="card-header bg-info">
                <h3 class="card-title">Grafik Kinerja Teknisi</h3>
            </div>
            <div class="card-body">
                <canvas id="technicianChart" height="80"></canvas>
            </div>
        </div>

        <!-- Statistik Teknisi Table -->
        <div class="card">
            <div class="card-header bg-success">
                <h3 class="card-title">Statistik Per Teknisi</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Teknisi</th>
                            <th class="text-center">Total Service</th>
                            <th class="text-center">Selesai</th>
                            <th class="text-center">Dalam Proses</th>
                            <th class="text-center">Dibatalkan</th>
                            <th class="text-center">Success Rate</th>
                            <th class="text-center">Avg. Durasi</th>
                            <th class="text-right">Total Pendapatan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $technicianStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><strong><?php echo e($stat['technician_name']); ?></strong></td>
                            <td class="text-center"><?php echo e($stat['total_services']); ?></td>
                            <td class="text-center">
                                <span class="badge badge-success"><?php echo e($stat['completed']); ?></span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-info"><?php echo e($stat['in_progress']); ?></span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-danger"><?php echo e($stat['cancelled']); ?></span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-<?php echo e($stat['success_rate'] >= 80 ? 'success' : ($stat['success_rate'] >= 60 ? 'warning' : 'danger')); ?>">
                                    <?php echo e($stat['success_rate']); ?>%
                                </span>
                            </td>
                            <td class="text-center"><?php echo e($stat['avg_duration_days']); ?> hari</td>
                            <td class="text-right">Rp <?php echo e(number_format($stat['total_revenue'], 0, ',', '.')); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr class="font-weight-bold bg-light">
                            <td>TOTAL</td>
                            <td class="text-center"><?php echo e($technicianStats->sum('total_services')); ?></td>
                            <td class="text-center"><?php echo e($technicianStats->sum('completed')); ?></td>
                            <td class="text-center"><?php echo e($technicianStats->sum('in_progress')); ?></td>
                            <td class="text-center"><?php echo e($technicianStats->sum('cancelled')); ?></td>
                            <td class="text-center">-</td>
                            <td class="text-center">-</td>
                            <td class="text-right">Rp <?php echo e(number_format($technicianStats->sum('total_revenue'), 0, ',', '.')); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Detail Services per Teknisi -->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title">Detail Service</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm" id="serviceTable">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Teknisi</th>
                            <th>Status</th>
                            <th>Durasi</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><a href="<?php echo e(route('services.show', $service->id)); ?>"><?php echo e($service->service_number); ?></a></td>
                            <td><?php echo e($service->service_date->format('d/m/Y')); ?></td>
                            <td><?php echo e($service->customer->name); ?></td>
                            <td><?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?></td>
                            <td><?php echo e($service->technician->name ?? '-'); ?></td>
                            <td>
                                <?php
                                $badgeClass = match($service->status) {
                                    'selesai' => 'success',
                                    'dibatalkan' => 'danger',
                                    'siap diambil' => 'primary',
                                    default => 'warning'
                                };
                                ?>
                                <span class="badge badge-<?php echo e($badgeClass); ?>"><?php echo e(ucwords($service->status)); ?></span>
                            </td>
                            <td>
                                <?php if($service->completed_at): ?>
                                <?php echo e($service->service_date->diffInDays($service->completed_at)); ?> hari
                                <?php else: ?>
                                <?php echo e($service->service_date->diffInDays(now())); ?> hari (berjalan)
                                <?php endif; ?>
                            </td>
                            <td class="text-right">Rp <?php echo e(number_format($service->total_cost, 0, ',', '.')); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
$(document).ready(function() {
    $('#serviceTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[1, 'desc']]
    });

    // Bar Chart Teknisi
    const ctx = document.getElementById('technicianChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($chartLabels, 15, 512) ?>,
            datasets: [
                {
                    label: 'Selesai',
                    data: <?php echo json_encode($chartDataCompleted, 15, 512) ?>,
                    backgroundColor: '#4CAF50'
                },
                {
                    label: 'Dalam Proses',
                    data: <?php echo json_encode($chartDataInProgress, 15, 512) ?>,
                    backgroundColor: '#2196F3'
                },
                {
                    label: 'Dibatalkan',
                    data: <?php echo json_encode($chartDataCancelled, 15, 512) ?>,
                    backgroundColor: '#F44336'
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            scales: {
                x: {
                    stacked: true
                },
                y: {
                    stacked: true,
                    beginAtZero: true
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                }
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/service/technician.blade.php ENDPATH**/ ?>