<?php $__env->startSection('heading', 'Detail Produk'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Produk</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('product')); ?>">Produk</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Product Info Card -->
            <div class="col-md-4">
                <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                        <div class="text-center mb-3">
                            <div class="p-3 bg-light rounded">
                                <?php echo generateQrCode($product->barcode, 150); ?>

                            </div>
                            <p class="text-muted mt-2 mb-0">Scan untuk detail</p>
                            <small class="text-muted"><?php echo e($product->barcode); ?></small>
                        </div>

                        <h3 class="profile-username text-center"><?php echo e($product->name); ?></h3>

                        <p class="text-muted text-center">
                            <span class="badge badge-info"><?php echo e($product->category->name); ?></span>
                            <span class="badge badge-secondary"><?php echo e($product->brand->name); ?></span>
                        </p>

                        <ul class="list-group list-group-unbordered mb-3">
                            <li class="list-group-item">
                                <b>Total Stok</b>
                                <a class="float-right">
                                    <span class="badge badge-lg badge-<?php echo e($totalStock < $product->min_stock ? 'danger' : 'success'); ?>">
                                        <?php echo e(number_format($totalStock, 0, ',', '.')); ?> <?php echo e($product->unit); ?>

                                    </span>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>Min. Stok</b>
                                <a class="float-right">
                                    <span class="badge badge-warning">
                                        <?php echo e(number_format($product->min_stock, 0, ',', '.')); ?> <?php echo e($product->unit); ?>

                                    </span>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>Nilai Stok</b>
                                <a class="float-right">
                                    <strong class="text-success">Rp <?php echo e(number_format($stockValue, 0, ',', '.')); ?></strong>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <b>Status Stok</b>
                                <a class="float-right">
                                    <?php if($totalStock >= $product->min_stock): ?>
                                    <span class="badge badge-success">Tersedia</span>
                                    <?php elseif($totalStock > 0): ?>
                                    <span class="badge badge-warning">Stok Rendah</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">Habis</span>
                                    <?php endif; ?>
                                </a>
                            </li>
                        </ul>

                        <?php if($product->description): ?>
                        <hr>
                        <strong><i class="fas fa-info-circle mr-1"></i> Deskripsi</strong>
                        <p class="text-muted mt-2">
                            <?php echo e($product->description); ?>

                        </p>
                        <?php endif; ?>

                        <a href="<?php echo e(route('product')); ?>" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-8">
                <!-- Stock per Branch -->
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-warehouse mr-2"></i>Stok Per Cabang</h3>
                    </div>
                    <div class="card-body">
                        <?php if($product->productStocks->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Cabang</th>
                                        <th class="text-center">Stok</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-right">Nilai Stok</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $product->productStocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $price = $product->productPrices
                                            ->where('branch_id', $stock->branch_id)
                                            ->sortByDesc('effective_date')
                                            ->first();
                                        $value = $price ? ($stock->quantity * $price->purchase_price) : 0;
                                    ?>
                                    <tr>
                                        <td>
                                            <i class="far fa-building mr-2 text-primary"></i>
                                            <strong><?php echo e($stock->branch->name); ?></strong>
                                        </td>
                                        <td class="text-center">
                                            <h5 class="mb-0">
                                                <span class="badge badge-<?php echo e($stock->quantity < $product->min_stock ? 'danger' : 'info'); ?>">
                                                    <?php echo e(number_format($stock->quantity, 0, ',', '.')); ?> <?php echo e($product->unit); ?>

                                                </span>
                                            </h5>
                                        </td>
                                        <td class="text-center">
                                            <?php if($stock->quantity >= $product->min_stock): ?>
                                            <span class="badge badge-success">Aman</span>
                                            <?php elseif($stock->quantity > 0): ?>
                                            <span class="badge badge-warning">Rendah</span>
                                            <?php else: ?>
                                            <span class="badge badge-danger">Habis</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-success">Rp <?php echo e(number_format($value, 0, ',', '.')); ?></strong>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr class="bg-light">
                                        <th>Total</th>
                                        <th class="text-center">
                                            <span class="badge badge-primary badge-lg">
                                                <?php echo e(number_format($totalStock, 0, ',', '.')); ?> <?php echo e($product->unit); ?>

                                            </span>
                                        </th>
                                        <th></th>
                                        <th class="text-right">
                                            <strong class="text-success">Rp <?php echo e(number_format($stockValue, 0, ',', '.')); ?></strong>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle mr-2"></i>
                            Belum ada data stok untuk produk ini.
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Price per Branch -->
                <div class="card card-warning">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-tags mr-2"></i>Harga Per Cabang</h3>
                    </div>
                    <div class="card-body">
                        <?php if($product->productPrices->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Cabang</th>
                                        <th class="text-right">Harga Beli</th>
                                        <th class="text-right">Harga Jual</th>
                                        <th class="text-right">Margin</th>
                                        <th class="text-center">Efektif</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $product->productPrices->sortBy('branch.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $margin = $price->selling_price - $price->purchase_price;
                                        $marginPercent = $price->purchase_price > 0 ? ($margin / $price->purchase_price * 100) : 0;
                                    ?>
                                    <tr>
                                        <td>
                                            <i class="far fa-building mr-2 text-warning"></i>
                                            <strong><?php echo e($price->branch->name); ?></strong>
                                        </td>
                                        <td class="text-right">
                                            <span class="badge badge-info">
                                                Rp <?php echo e(number_format($price->purchase_price, 0, ',', '.')); ?>

                                            </span>
                                        </td>
                                        <td class="text-right">
                                            <span class="badge badge-success">
                                                Rp <?php echo e(number_format($price->selling_price, 0, ',', '.')); ?>

                                            </span>
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-<?php echo e($margin > 0 ? 'success' : 'danger'); ?>">
                                                Rp <?php echo e(number_format($margin, 0, ',', '.')); ?>

                                                <small>(<?php echo e(number_format($marginPercent, 1)); ?>%)</small>
                                            </strong>
                                        </td>
                                        <td class="text-center">
                                            <small class="text-muted"><?php echo e(date('d/m/Y', strtotime($price->effective_date))); ?></small>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle mr-2"></i>
                            Belum ada data harga untuk produk ini.
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Product Statistics -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="info-box bg-info">
                            <span class="info-box-icon"><i class="fas fa-boxes"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Total Stok</span>
                                <span class="info-box-number"><?php echo e(number_format($totalStock, 0, ',', '.')); ?> <?php echo e($product->unit); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-box bg-success">
                            <span class="info-box-icon"><i class="fas fa-dollar-sign"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Nilai Total</span>
                                <span class="info-box-number">Rp <?php echo e(number_format($stockValue, 0, ',', '.')); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-box bg-warning">
                            <span class="info-box-icon"><i class="fas fa-warehouse"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Tersedia di</span>
                                <span class="info-box-number"><?php echo e($product->productStocks->count()); ?> Cabang</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/product/show.blade.php ENDPATH**/ ?>