<?php $__env->startSection('heading', 'Edit Stock Opname'); ?>


<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Edit Stock Opname</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('stock-opname')); ?>">Stock Opname</a></li>
                        <li class="breadcrumb-item active">Edit</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">

            <form action="<?php echo e(route('stock-opname.update', $stockOpname->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="row">

                    <!-- ================= LEFT ================= -->
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Detail Produk</h3>
                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Produk</th>
                                                <th>Satuan</th>
                                                <th>Stok Sistem</th>
                                                <th>Stok Fisik</th>
                                                <th>Selisih</th>
                                                <th>Catatan</th>
                                            </tr>
                                        </thead>

                                        <tbody id="detailBody">
                                            <?php $__currentLoopData = $stockOpname->stockOpnameDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                            $diff = $detail->physical_stock - $detail->system_stock;
                                            ?>
                                            <tr>
                                                <td>
                                                    <?php echo e($detail->product->name); ?>

                                                    <input type="hidden" name="details[<?php echo e($i); ?>][product_id]" value="<?php echo e($detail->product_id); ?>">
                                                    <input type="hidden" name="details[<?php echo e($i); ?>][system_stock]" value="<?php echo e($detail->system_stock); ?>" class="system-stock">
                                                </td>

                                                <td class="text-center">
                                                    <?php echo e($detail->product->unit); ?>

                                                </td>

                                                <td class="text-center">
                                                    <span class="badge badge-info"><?php echo e($detail->system_stock); ?></span>
                                                </td>

                                                <td>
                                                    <input type="number" name="details[<?php echo e($i); ?>][physical_stock]" class="form-control physical-input" value="<?php echo e($detail->physical_stock); ?>" min="0">
                                                </td>

                                                <td class="text-center">
                                                    <strong class="difference-text" data-system="<?php echo e($detail->system_stock); ?>">
                                                        <?php echo e($diff); ?>

                                                    </strong>
                                                </td>

                                                <td>
                                                    <input type="text" name="details[<?php echo e($i); ?>][notes]" class="form-control" value="<?php echo e($detail->notes); ?>">
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ================= RIGHT ================= -->
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Informasi Stock Opname</h3>
                            </div>

                            <div class="card-body">

                                <div class="form-group">
                                    <label>No Opname</label>
                                    <input type="text" class="form-control" value="<?php echo e($stockOpname->opname_number); ?>" readonly>
                                </div>

                                <div class="form-group">
                                    <label>Cabang</label>
                                    <input type="text" class="form-control" value="<?php echo e($stockOpname->branch->name); ?>" readonly>
                                    <input type="hidden" name="branch_id" value="<?php echo e($stockOpname->branch_id); ?>">
                                </div>

                                <div class="form-group">
                                    <label>Tanggal Opname</label>
                                    <input type="text" class="form-control" value="<?php echo e(\Carbon\Carbon::parse($stockOpname->opname_date)->format('d/m/Y')); ?>" readonly>
                                    <input type="hidden" name="opname_date" value="<?php echo e($stockOpname->opname_date); ?>">
                                </div>

                                <div class="form-group">
                                    <label>Catatan</label>
                                    <textarea class="form-control" readonly><?php echo e($stockOpname->notes); ?></textarea>
                                    <input type="hidden" name="notes" value="<?php echo e($stockOpname->notes); ?>">
                                </div>

                                <hr>

                                <div class="form-group">
                                    <label>Total Item Selisih</label>
                                    <h4 id="totalDifference">0 item</h4>
                                </div>

                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-success btn-block">
                                    <i class="fas fa-save"></i> Update Stock Opname
                                </button>
                                <a href="<?php echo e(route('stock-opname')); ?>" class="btn btn-secondary btn-block">
                                    Kembali
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </form>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<!-- ================= HITUNG SUBTOTAL & TOTAL ================= -->
<script>
    function updateTotalDifference() {
        let itemsWithDifference = 0;

        document.querySelectorAll('#detailBody tr').forEach(row => {
            const systemStock = row.querySelector('.system-stock');
            const physicalStock = row.querySelector('.physical-input');

            if (!systemStock || !physicalStock) return;

            const system = parseFloat(systemStock.value) || 0;
            const physical = parseFloat(physicalStock.value) || 0;

            if (system !== physical) {
                itemsWithDifference++;
            }
        });

        document.getElementById('totalDifference').textContent =
            itemsWithDifference + ' item';
    }

    document.addEventListener('DOMContentLoaded', function () {

        // hitung awal saat halaman dibuka
        updateTotalDifference();

        // update saat stok fisik diubah
        document.querySelectorAll('.physical-input').forEach(input => {
            input.addEventListener('input', function () {
                updateTotalDifference();
            });
        });
    });
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/stock-opname/edit.blade.php ENDPATH**/ ?>