<?php $__env->startSection('heading', 'Pergerakan Stok'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Histori Pergerakan Stok</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Pergerakan Stok</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Filter Data</h3>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="<?php echo e(route('stock-movement')); ?>">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Produk</label>
                                        <select name="product_id" class="form-control">
                                            <option value="">-- Semua Produk --</option>
                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($product->id); ?>" <?php echo e(request('product_id') == $product->id ? 'selected' : ''); ?>>
                                                <?php echo e($product->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Cabang</label>
                                        <select name="branch_id" class="form-control">
                                            <option value="">-- Semua Cabang --</option>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($branch->id); ?>" <?php echo e(request('branch_id') == $branch->id ? 'selected' : ''); ?>>
                                                <?php echo e($branch->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Tipe</label>
                                        <select name="type" class="form-control">
                                            <option value="">-- Semua Tipe --</option>
                                            <option value="in" <?php echo e(request('type') == 'in' ? 'selected' : ''); ?>>Masuk</option>
                                            <option value="out" <?php echo e(request('type') == 'out' ? 'selected' : ''); ?>>Keluar</option>
                                            <option value="adjustment" <?php echo e(request('type') == 'adjustment' ? 'selected' : ''); ?>>Penyesuaian</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Dari Tanggal</label>
                                        <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Sampai Tanggal</label>
                                        <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="submit" class="btn btn-primary btn-block">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Pergerakan Stok</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Tanggal</th>
                                    <th>Produk</th>
                                    <th>Cabang</th>
                                    <th>Tipe</th>
                                    <th>Qty</th>
                                    <th>Referensi</th>
                                    <th>Catatan</th>
                                    <th>User</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $stockMovements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $movement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($stockMovements->firstItem() + $index); ?></td>
                                    <td><?php echo e(TanggalID($movement->created_at)); ?></td>
                                    <td><?php echo e($movement->product->name); ?></td>
                                    <td><?php echo e($movement->branch->name); ?></td>
                                    <td>
                                        <?php if($movement->type == 'in'): ?>
                                        <span class="badge badge-success">Masuk</span>
                                        <?php elseif($movement->type == 'out'): ?>
                                        <span class="badge badge-danger">Keluar</span>
                                        <?php else: ?>
                                        <span class="badge badge-warning">Penyesuaian</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($movement->type == 'in'): ?>
                                        <span class="text-success">+<?php echo e(number_format($movement->quantity, 0, ',', '.')); ?></span>
                                        <?php elseif($movement->type == 'out'): ?>
                                        <span class="text-danger">-<?php echo e(number_format($movement->quantity, 0, ',', '.')); ?></span>
                                        <?php else: ?>
                                        <?php echo e(number_format($movement->quantity, 0, ',', '.')); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($movement->reference_type == 'App\Models\Purchase'): ?>
                                        <span class="badge badge-info">Pembelian</span>
                                        <?php elseif($movement->reference_type == 'App\Models\Sale'): ?>
                                        <span class="badge badge-primary">Penjualan</span>
                                        <?php elseif($movement->reference_type == 'App\Models\StockOpname'): ?>
                                        <span class="badge badge-warning">Stock Opname</span>
                                        <?php else: ?>
                                        -
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($movement->notes ?? '-'); ?></td>
                                    <td><?php echo e($movement->user->name); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">Tidak ada data</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer clearfix">
                        <?php echo e($stockMovements->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/stock-movement/index.blade.php ENDPATH**/ ?>