<?php $__env->startSection('heading', 'Detail Stock Opname'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Stock Opname</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('stock-opname')); ?>">Stock Opname</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detail Produk</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Produk</th>
                                    <th style="width: 12%;">Stok Sistem</th>
                                    <th style="width: 12%;">Stok Fisik</th>
                                    <th style="width: 12%;">Selisih</th>
                                    <th style="width: 20%;">Catatan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $stockOpname->stockOpnameDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($detail->product->name); ?></td>
                                    <td class="text-center"><?php echo e(number_format($detail->system_stock, 0, ',', '.')); ?></td>
                                    <td class="text-center"><?php echo e(number_format($detail->physical_stock, 0, ',', '.')); ?></td>
                                    <td class="text-center">
                                        <?php if($detail->difference > 0): ?>
                                        <span class="badge badge-success">+<?php echo e(number_format($detail->difference, 0, ',', '.')); ?></span>
                                        <?php elseif($detail->difference < 0): ?>
                                        <span class="badge badge-danger"><?php echo e(number_format($detail->difference, 0, ',', '.')); ?></span>
                                        <?php else: ?>
                                        <span class="badge badge-secondary">0</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($detail->notes ?? '-'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Stock Opname</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 40%;">No. Opname</th>
                                <td><?php echo e($stockOpname->opname_number); ?></td>
                            </tr>
                            <tr>
                                <th>Cabang</th>
                                <td><?php echo e($stockOpname->branch->name); ?></td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td><?php echo e(TanggalID($stockOpname->opname_date)); ?></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <?php if($stockOpname->status == 'pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                    <?php elseif($stockOpname->status == 'completed'): ?>
                                    <span class="badge badge-success">Selesai</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">Batal</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>User</th>
                                <td><?php echo e($stockOpname->user->name); ?></td>
                            </tr>
                            <tr>
                                <th>Total Item</th>
                                <td><?php echo e($stockOpname->stockOpnameDetails->count()); ?> item</td>
                            </tr>
                            <?php if($stockOpname->notes): ?>
                            <tr>
                                <th>Catatan</th>
                                <td><?php echo e($stockOpname->notes); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Dibuat</th>
                                <td><?php echo e(TanggalID($stockOpname->created_at)); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="card-footer">
                        <a href="<?php echo e(route('stock-opname')); ?>" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock-opnames.edit')): ?>
                        <?php if($stockOpname->status == 'pending'): ?>
                        <a href="<?php echo e(route('stock-opname.edit', $stockOpname->id)); ?>" class="btn btn-primary btn-block">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/stock-opname/show.blade.php ENDPATH**/ ?>