<?php $__env->startSection('heading', 'Laporan Service Berdasarkan Status'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Laporan Service Berdasarkan Status </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Laporan Service - Status </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Filter Form -->
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Filter Laporan</h3>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('report.service.status')); ?>" method="GET">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Mulai</label>
                                <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Akhir</label>
                                <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Cabang</label>
                                <select name="branch_id" class="form-control">
                                    <option value="">Semua Cabang</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($branch->id); ?>" <?php echo e($branchId == $branch->id ? 'selected' : ''); ?>>
                                        <?php echo e($branch->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Tampilkan
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('report.service.status.export-pdf', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])); ?>" class="btn btn-danger" target="_blank">
                            <i class="fas fa-file-pdf"></i> Export PDF
                        </a>
                        <a href="<?php echo e(route('report.service.status.export-excel', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])); ?>" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> Export Excel
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3><?php echo e($services->count()); ?></h3>
                        <p>Total Service</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-wrench"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3><?php echo e($services->where('status', 'selesai')->count()); ?></h3>
                        <p>Selesai</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3><?php echo e($delayedServices->count()); ?></h3>
                        <p>Tertunda (>3 hari)</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3><?php echo e($readyToPickup->count()); ?></h3>
                        <p>Siap Diambil</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-bell"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart & Status Table -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-info">
                        <h3 class="card-title">Distribusi Status Service</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="statusChart" height="200"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-info">
                        <h3 class="card-title">Statistik Per Status</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th>Status</th>
                                    <th class="text-center">Jumlah</th>
                                    <th class="text-right">Total Nilai</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $statusStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(ucwords($status)); ?></td>
                                    <td class="text-center"><?php echo e($stat['count']); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($stat['total_value'], 0, ',', '.')); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr class="font-weight-bold">
                                    <td>TOTAL</td>
                                    <td class="text-center"><?php echo e($services->count()); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($services->sum('total_cost'), 0, ',', '.')); ?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Service Tertunda -->
        <?php if($delayedServices->count() > 0): ?>
        <div class="card">
            <div class="card-header bg-warning">
                <h3 class="card-title">Service Tertunda (>3 hari)</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Status</th>
                            <th>Teknisi</th>
                            <th>Lama (Hari)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $delayedServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><a href="<?php echo e(route('services.show', $service->id)); ?>"><?php echo e($service->service_number); ?></a></td>
                            <td><?php echo e($service->service_date->format('d/m/Y')); ?></td>
                            <td><?php echo e($service->customer->name); ?></td>
                            <td><?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?></td>
                            <td><span class="badge badge-warning"><?php echo e(ucwords($service->status)); ?></span></td>
                            <td><?php echo e($service->technician->name ?? '-'); ?></td>
                            <td><?php echo e($service->service_date->diffInDays(now())); ?> hari</td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <!-- Service Siap Diambil -->
        <?php if($readyToPickup->count() > 0): ?>
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Service Siap Diambil</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Teknisi</th>
                            <th>Total Biaya</th>
                            <th>Sisa Bayar</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $readyToPickup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><a href="<?php echo e(route('services.show', $service->id)); ?>"><?php echo e($service->service_number); ?></a></td>
                            <td><?php echo e($service->service_date->format('d/m/Y')); ?></td>
                            <td><?php echo e($service->customer->name); ?></td>
                            <td><?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?></td>
                            <td><?php echo e($service->technician->name ?? '-'); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($service->total_cost, 0, ',', '.')); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($service->remaining_payment, 0, ',', '.')); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <!-- Detail All Services -->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title">Detail Semua Service</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm" id="serviceTable">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Status</th>
                            <th>Cabang</th>
                            <th>Teknisi</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><a href="<?php echo e(route('services.show', $service->id)); ?>"><?php echo e($service->service_number); ?></a></td>
                            <td><?php echo e($service->service_date->format('d/m/Y')); ?></td>
                            <td><?php echo e($service->customer->name); ?></td>
                            <td><?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?></td>
                            <td>
                                <?php
                                $badgeClass = match($service->status) {
                                    'menunggu diagnosa' => 'warning',
                                    'sedang diagnosa' => 'info',
                                    'menunggu persetujuan' => 'primary',
                                    'menunggu spare part' => 'secondary',
                                    'dalam pengerjaan' => 'info',
                                    'quality control' => 'success',
                                    'siap diambil' => 'primary',
                                    'selesai' => 'success',
                                    'dibatalkan' => 'danger',
                                    default => 'secondary'
                                };
                                ?>
                                <span class="badge badge-<?php echo e($badgeClass); ?>"><?php echo e(ucwords($service->status)); ?></span>
                            </td>
                            <td><?php echo e($service->branch->name); ?></td>
                            <td><?php echo e($service->technician->name ?? '-'); ?></td>
                            <td class="text-right">Rp <?php echo e(number_format($service->total_cost, 0, ',', '.')); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
$(document).ready(function() {
    $('#serviceTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[1, 'desc']]
    });

    // Pie Chart Status
    const ctx = document.getElementById('statusChart').getContext('2d');
    new Chart(ctx, {
        type: 'pie',
        data: {
            labels: <?php echo json_encode($chartLabels, 15, 512) ?>,
            datasets: [{
                data: <?php echo json_encode($chartData, 15, 512) ?>,
                backgroundColor: [
                    '#FFC107', '#FF9800', '#2196F3', '#9C27B0',
                    '#00BCD4', '#4CAF50', '#8BC34A', '#4CAF50', '#F44336'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/service/status.blade.php ENDPATH**/ ?>