@section('heading', 'Stock Opname')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Stock Opname</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Stock Opname</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Stock Opname</h3>
                        @can('stock-opnames.create')
                        <div class="card-tools">
                            <a href="{{route('stock-opname.create')}}" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Stock Opname
                            </a>
                        </div>
                        @endcan
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Opname</th>
                                    <th>Tanggal</th>
                                    <th>Cabang</th>
                                    <th>Jumlah Item</th>
                                    <th>Status</th>
                                    <th>User</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($stockOpnames as $index => $opname)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$opname->opname_number}}</td>
                                    <td>{{TanggalID($opname->opname_date)}}</td>
                                    <td>{{$opname->branch->name}}</td>
                                    <td>{{$opname->stockOpnameDetails->count()}} item</td>
                                    <td>
                                        @if($opname->status == 'pending')
                                        <span class="badge badge-warning">Pending</span>
                                        @elseif($opname->status == 'completed')
                                        <span class="badge badge-success">Selesai</span>
                                        @else
                                        <span class="badge badge-danger">Batal</span>
                                        @endif
                                    </td>
                                    <td>{{$opname->user->name}}</td>
                                    <td>
                                        @can('stock-opnames.index')
                                        <a href="{{route('stock-opname.show', $opname->id)}}" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @endcan

                                        @can('stock-opnames.edit')
                                        {{-- @if($opname->status == 'pending') --}}
                                        <a href="{{route('stock-opname.edit', $opname->id)}}" class="btn btn-primary btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        {{-- @endif --}}
                                        @endcan

                                        @can('stock-opnames.delete')
                                        {{-- @if($opname->status == 'pending') --}}
                                        <form action="{{ route('stock-opname.delete', $opname->id) }}" method="POST" style="display:inline;" class="delete-form-{{ $opname->id }}">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm delete" data-id="{{ $opname->id }}" data-name="Stock Opname {{ $opname->sale_number }}" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        {{-- @endif --}}
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
