@section('heading', 'Detail Penjualan')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Penjualan</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{route('sale')}}">Penjualan</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detail Produk</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Produk</th>
                                    <th style="width: 12%;">Qty</th>
                                    <th style="width: 18%;">Harga</th>
                                    <th style="width: 15%;">Diskon</th>
                                    <th style="width: 18%;">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($sale->saleDetails as $index => $detail)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$detail->product->name}}</td>
                                    <td>{{number_format($detail->quantity, 0, ',', '.')}} {{$detail->product->unit}}</td>
                                    <td class="text-right">Rp {{number_format($detail->selling_price, 0, ',', '.')}}</td>
                                    <td class="text-right">Rp {{number_format($detail->discount, 0, ',', '.')}}</td>
                                    <td class="text-right">Rp {{number_format($detail->subtotal, 0, ',', '.')}}</td>
                                </tr>
                                @endforeach
                                <tr>
                                    <th colspan="5" class="text-right">Subtotal</th>
                                    <th class="text-right">Rp {{number_format($sale->subtotal, 0, ',', '.')}}</th>
                                </tr>
                                <tr>
                                    <th colspan="5" class="text-right">Diskon</th>
                                    <th class="text-right">Rp {{number_format($sale->discount, 0, ',', '.')}}</th>
                                </tr>
                                <tr>
                                    <th colspan="5" class="text-right">Pajak</th>
                                    <th class="text-right">Rp {{number_format($sale->tax, 0, ',', '.')}}</th>
                                </tr>
                                <tr>
                                    <th colspan="5" class="text-right">Total</th>
                                    <th class="text-right text-success">Rp {{number_format($sale->total_amount, 0, ',', '.')}}</th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Penjualan</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 40%;">No. Penjualan</th>
                                <td>{{$sale->sale_number}}</td>
                            </tr>
                            <tr>
                                <th>Customer</th>
                                <td>{{$sale->customer ? $sale->customer->name : 'Umum'}}</td>
                            </tr>
                            <tr>
                                <th>Cabang</th>
                                <td>{{$sale->branch->name}}</td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td>{{TanggalID($sale->sale_date)}}</td>
                            </tr>
                            <tr>
                                <th>Metode Bayar</th>
                                <td>
                                    @if($sale->payment_method == 'cash')
                                    <span class="badge badge-success">Tunai</span>
                                    @elseif($sale->payment_method == 'transfer')
                                    <span class="badge badge-info">Transfer</span>
                                    @else
                                    <span class="badge badge-warning">Kredit</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($sale->status == 'pending')
                                    <span class="badge badge-warning">Pending</span>
                                    @elseif($sale->status == 'completed')
                                    <span class="badge badge-success">Selesai</span>
                                    @else
                                    <span class="badge badge-danger">Batal</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Kasir</th>
                                <td>{{$sale->cashier->name}}</td>
                            </tr>
                            @if($sale->notes)
                            <tr>
                                <th>Catatan</th>
                                <td>{{$sale->notes}}</td>
                            </tr>
                            @endif
                            <tr>
                                <th>Dibuat</th>
                                <td>{{TanggalID($sale->created_at)}}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="card-footer">
                        <a href="{{route('sale')}}" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <a href="{{route('sale.invoice-pdf', $sale->id)}}" class="btn btn-success btn-block" target="_blank">
                            <i class="fas fa-print"></i> Cetak Faktur
                        </a>
                        @can('sales.edit')
                        @if($sale->status == 'pending')
                        <a href="{{route('sale.edit', $sale->id)}}" class="btn btn-primary btn-block">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        @endif
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
