@section('heading', 'Dashboard')

@extends('layouts.app')

@section('content')

<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Dashboard</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Row 1: Produk yang Sudah Mencapai Batas Min Stok (CARD-12) -->
        <div class="row">
            <div class="col-12">
                <div class="card card-danger">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-exclamation-triangle"></i> Produk yang Sudah Mencapai Batas Minimum Stok</h3>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped table-sm">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Kode Produk</th>
                                    <th>Nama Produk</th>
                                    <th>Cabang</th>
                                    <th class="text-center">Stok Saat Ini</th>
                                    <th class="text-center">Stok Minimum</th>
                                    <th class="text-center">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($lowStockProducts as $index => $item)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>B-{{ str_pad($item->product->id, 4, '0', STR_PAD_LEFT) }}</td>
                                        <td>{{ $item->product->name }}</td>
                                        <td>{{ $item->branch->name ?? '-' }}</td>
                                        <td class="text-center">
                                            <span class="badge badge-danger">{{ number_format($item->quantity) }} {{ $item->product->unit }}</span>
                                        </td>
                                        <td class="text-center">{{ number_format($item->product->min_stock) }} {{ $item->product->unit }}</td>
                                        <td class="text-center">
                                            @if($item->quantity == 0)
                                                <span class="badge badge-dark">Habis</span>
                                            @elseif($item->quantity < $item->product->min_stock)
                                                <span class="badge badge-danger">Di Bawah Minimum</span>
                                            @else
                                                <span class="badge badge-warning">Mencapai Minimum</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">
                                            <div class="alert alert-success mb-0">
                                                <i class="fas fa-check-circle"></i> Semua produk masih aman, tidak ada yang mencapai batas minimum stok
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Row 2: Peringkat Produk Terlaris & Peringkat Customer (CARD-4 + CARD-4 + CARD-4) -->
        <div class="row">
            <!-- Peringkat Produk Terlaris -->
            <div class="col-md-6">
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-chart-line"></i> Peringkat Produk Terlaris</h3>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Produk</th>
                                    <th class="text-center">Terjual</th>
                                    <th class="text-right">Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($topSellingProducts as $index => $item)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <strong>{{ $item->product->name }}</strong><br>
                                            <small class="text-muted">{{ $item->product->brand->name ?? '-' }}</small>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge badge-success">{{ number_format($item->total_sold) }}</span>
                                        </td>
                                        <td class="text-right">
                                            <small>Rp {{ number_format($item->total_revenue, 0, ',', '.') }}</small>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center text-muted">Belum ada data penjualan</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Peringkat Customer -->
            <div class="col-md-6">
                <div class="card card-info">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-users"></i> Peringkat Customer</h3>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Customer</th>
                                    <th class="text-center">Transaksi</th>
                                    <th class="text-right">Total Belanja</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($topCustomers as $index => $item)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <strong>{{ $item->customer->name ?? '-' }}</strong><br>
                                            <small class="text-muted">{{ $item->customer->phone ?? '-' }}</small>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge badge-info">{{ number_format($item->total_transactions) }}x</span>
                                        </td>
                                        <td class="text-right">
                                            <small>Rp {{ number_format($item->total_spending, 0, ',', '.') }}</small>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center text-muted">Belum ada data customer</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection
