@section('heading', 'Merek')

@extends('layouts.app')

@section('content')


<style>
    .warning {
        background-color: yellow;
    }

</style>


<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1> Merek </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{route('home')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active"> Merek </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"> <b>Merek</b> </h3>
                        <div class="card-tools">
                            @can('brands.create')
                                <button type="button" class="btn btn-success text-white btn-sm m-1" title="Tambah" data-toggle="modal" data-target="#modal-tambah">
                                    <i class="fas fa-plus-circle"></i> Tambah
                                </button>
                                <div class="modal fade" id="modal-tambah">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title"> Tambah Merek </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="{{ route('brand.save') }}" method="POST" enctype="multipart/form-data" id="form-tambah-brand">
                                                @csrf
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>Nama Merek <span class="text-danger">*</span></label>
                                                        <input type="text" name="name" value="{{ old('name') }}" placeholder="Masukkan Nama Merek" class="form-control @error('name') is-invalid @enderror" required>
                                                        @error('name')
                                                        <div class="invalid-feedback" style="display: block">
                                                            {{ $message }}
                                                        </div>
                                                        @enderror
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary btn-submit">
                                                            <i class="fa fa-paper-plane"></i> Simpan
                                                        </button>
                                                        <button class="btn btn-warning text-white btn-reset" type="reset">
                                                            <i class="fa fa-redo"></i> Reset
                                                        </button>
                                                        <button type="button" class="btn btn-default" data-dismiss="modal">
                                                            <i class="fas fa-undo"></i> Kembali
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                             @endcan
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th scope="col" style="text-align: center;width: 6%">NO.</th>
                                    <th scope="col">Nama Merek</th>
                                    <th scope="col" style="width: 15%;text-align: center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nomer = 1; ?>
                                @foreach ($brands as $no => $brand)
                                <tr>
                                    <th>{{ $nomer++}}</th>
                                    <td>{{ $brand->name }}</td>
                                    <td>{{ $brand->address }}</td>
                                    <td>{{ $brand->phone }}</td>
                                    <td class="text-left">
                                        @can('brands.edit')
                                            <button type="button" class="btn btn-warning text-white btn-sm m-1" title="Edit" data-toggle="modal" data-target="#modal-edit-{{ $brand->id }}">
                                                <i class="fas fa-pencil-alt"></i>
                                            </button>
                                            <div class="modal fade" id="modal-edit-{{ $brand->id }}">
                                                <div class="modal-dialog modal-xl">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"> Edit Data </h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('brand.update', $brand->id) }}" method="POST" enctype="multipart/form-data" class="form-edit-brand">
                                                            @csrf
                                                            @method('PUT')
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label>Nama Merek <span class="text-danger">*</span></label>
                                                                    <input type="text" name="name" value="{{ old('name', $brand->name) }}" placeholder="Masukkan Nama Merek" class="form-control @error('name') is-invalid @enderror" required>
                                                                    @error('name')
                                                                    <div class="invalid-feedback" style="display: block">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-primary btn-submit">
                                                                    <i class="fa fa-paper-plane"></i> Simpan
                                                                </button>
                                                                <button class="btn btn-warning text-white btn-reset" type="reset">
                                                                    <i class="fa fa-redo"></i> Reset
                                                                </button>
                                                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                                                    <i class="fas fa-undo"></i> Kembali
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endcan
                                        @can('brands.delete')
                                            <form action="{{ route('brand.delete', $brand->id) }}" method="POST" style="display:inline;" class="delete-form-{{ $brand->id }}">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" class="btn btn-danger btn-sm delete m-1" data-id="{{ $brand->id}}" data-name="{{ $brand->name}}" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->

@endsection



