<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    protected $fillable = [
        'service_number',
        'customer_id',
        'branch_id',
        'technician_id',
        'service_date',
        'device_type',
        'device_brand',
        'device_model',
        'imei',
        'complaint',
        'diagnosis',
        'estimated_cost',
        'service_fee',
        'parts_cost',
        'total_cost',
        'down_payment',
        'remaining_payment',
        'status',
        'priority',
        'estimated_completion',
        'completed_at',
        'notes',
    ];

    protected $casts = [
        'service_date' => 'date',
        'estimated_cost' => 'decimal:2',
        'service_fee' => 'decimal:2',
        'parts_cost' => 'decimal:2',
        'total_cost' => 'decimal:2',
        'down_payment' => 'decimal:2',
        'remaining_payment' => 'decimal:2',
        'estimated_completion' => 'datetime',
        'completed_at' => 'datetime',
    ];

    // Relasi ke Customer
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    // Relasi ke Branch
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    // Relasi ke Technician (User)
    public function technician()
    {
        return $this->belongsTo(User::class, 'technician_id');
    }

    // Relasi ke Service Details (Spare Part)
    public function serviceDetails()
    {
        return $this->hasMany(ServiceDetail::class);
    }

    // Relasi ke Status Histories
    public function statusHistories()
    {
        return $this->hasMany(ServiceStatusHistory::class);
    }
}
