<?php

namespace App\Http\Controllers\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Branch;

class BranchesController extends Controller
{
    public function __construct()
    {
        $this->middleware(['permission:branches.index'])->only('index');
        $this->middleware(['permission:branches.create'])->only('save');
        $this->middleware(['permission:branches.edit'])->only('update');
        $this->middleware(['permission:branches.delete'])->only('delete');
    }

    public function index()
    {
        $title = "branch";
        $branches = Branch::orderBy('id', 'desc')->get();

        return view('master.branch', compact('title','branches'));
    }

    public function save(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:branches'
        ]);

        $branch = Branch::create([
            'name' => $request->input('name'),
            'address' => $request->input('address'),
            'phone' => $request->input('phone'),
            'is_active' => '1'
        ]);

        if($branch){
            //redirect dengan pesan sukses
            return redirect()->route('branch')->with(['success' => 'Data Berhasil Disimpan!']);
        }else{
            //redirect dengan pesan error
            return redirect()->route('branch')->with(['error' => 'Data Gagal Disimpan!']);
        }
    }

    public function update(Request $request, Branch $branch)
    {
        $this->validate($request, [
            'name' => 'required|unique:branches,name,'.$branch->id
        ]);

        $branch = Branch::findOrFail($branch->id);
        $branch->update([
            'name' => $request->input('name'),
            'address' => $request->input('address'),
            'phone' => $request->input('phone')
        ]);

        if($branch){
            //redirect dengan pesan sukses
            return redirect()->route('branch')->with(['success' => 'Data Berhasil Disimpan!']);
        }else{
            //redirect dengan pesan error
            return redirect()->route('branch')->with(['error' => 'Data Gagal Disimpan!']);
        }
    }

    public function delete(Branch $branch)
    {
        $branch->delete();

        return redirect()->route('branch')->with('success', 'Data Berhasil Dihapus');
    }

}
