@section('heading', 'Edit Pembelian')
@extends('layouts.app')

@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Edit Pembelian</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('purchase') }}">Pembelian</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <form action="{{ route('purchase.update', $purchase->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <!-- ================= LEFT ================= -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Detail Produk</h3>
                        </div>
                        <div class="card-body">

                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Produk</th>
                                            <th>Satuan</th>
                                            <th>Qty</th>
                                            <th>Harga</th>
                                            <th>Sub Total</th>
                                        </tr>
                                    </thead>

                                    <tbody id="detailBody">
                                        @foreach($purchase->purchaseDetails as $i => $detail)
                                        <tr id="row-{{ $i }}">
                                            <td>
                                                {{ $detail->product->name }}
                                                <input type="hidden" name="details[{{ $i }}][product_id]" value="{{ $detail->product_id }}">
                                            </td>
                                            <td class="text-center">{{ $detail->product->unit }}</td>
                                            <td>
                                                <input type="number" name="details[{{ $i }}][quantity]" class="form-control qty-input" value="{{ $detail->quantity }}" min="1">
                                            </td>
                                            <td>
                                                <input type="number" name="details[{{ $i }}][purchase_price]" class="form-control price-input" value="{{ $detail->purchase_price }}" min="0">
                                            </td>
                                            <td class="text-right subtotal-cell">
                                                <strong class="subtotal-text" data-subtotal="{{ $detail->subtotal }}">
                                                    Rp {{ number_format($detail->subtotal,0,',','.') }}
                                                </strong>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- ================= RIGHT ================= -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Informasi Pembelian</h3>
                        </div>

                        <div class="card-body">

                            <div class="form-group">
                                <label>No Pembelian</label>
                                <input type="text" class="form-control" value="{{ $purchase->purchase_number }}" readonly>
                            </div>

                            <div class="form-group">
                                <label>Supplier</label>
                                <input type="text" class="form-control" value="{{ $purchase->supplier->name }}" readonly>
                                <input type="hidden" name="supplier_id" value="{{ $purchase->supplier_id }}">
                            </div>

                            <div class="form-group">
                                <label>Cabang</label>
                                <input type="text" class="form-control" value="{{ $purchase->branch->name }}" readonly>
                                <input type="hidden" name="branch_id" value="{{ $purchase->branch_id }}">
                            </div>

                            <div class="form-group">
                                <label>Tanggal Pembelian</label>
                                <input type="text" class="form-control" value="{{ \Carbon\Carbon::parse($purchase->purchase_date)->format('d/m/Y') }}" readonly>
                                <input type="hidden" name="purchase_date" value="{{ $purchase->purchase_date }}">
                            </div>

                            <div class="form-group">
                                <label>Catatan</label>
                                <textarea readonly name="notes" class="form-control">{{ $purchase->notes }}</textarea>
                            </div>

                            <hr>

                            <div class="form-group">
                                <label>Total Pembelian</label>
                                <h3 class="text-success" id="totalAmount">
                                    Rp {{ number_format($purchase->total_amount,0,',','.') }}
                                </h3>
                            </div>

                        </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-success btn-block">
                                <i class="fas fa-save"></i> Update Pembelian
                            </button>
                            <a href="{{ route('purchase') }}" class="btn btn-secondary btn-block">Kembali</a>
                        </div>

                    </div>
                </div>

            </div>
        </form>
    </div>
</section>
@endsection

<!-- ================= Qty dan Sub Total ================= -->
<script>
    function formatRupiah(number) {
        return 'Rp ' + number.toLocaleString('id-ID');
    }

    function updateRowSubtotal(row) {
        const qtyInput = row.querySelector('.qty-input');
        const priceInput = row.querySelector('.price-input');
        const subtotalText = row.querySelector('.subtotal-text');

        const qty = parseFloat(qtyInput.value) || 0;
        const price = parseFloat(priceInput.value) || 0;

        const subtotal = qty * price;

        subtotalText.textContent = formatRupiah(subtotal);
        subtotalText.dataset.subtotal = subtotal;

        updateTotal();
    }

    function updateTotal() {
        let total = 0;

        document.querySelectorAll('.subtotal-text').forEach(el => {
            total += parseFloat(el.dataset.subtotal) || 0;
        });

        document.getElementById('totalAmount').textContent = formatRupiah(total);
    }

    // EVENT LISTENER UNTUK QTY & HARGA
    document.addEventListener('DOMContentLoaded', function () {

        document.querySelectorAll('.qty-input, .price-input').forEach(input => {
            input.addEventListener('input', function () {
                const row = this.closest('tr');
                updateRowSubtotal(row);
            });
        });

    });
</script>
