<!DOCTYPE html>
<html>
<head>
    <title>Laporan Service Berdasarkan Status</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 16px;
        }
        .header p {
            margin: 3px 0;
            font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table th {
            background-color: #FFC107;
            color: white;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        table td {
            border: 1px solid #ddd;
            padding: 6px;
            font-size: 10px;
        }
        table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .summary {
            margin-top: 15px;
            margin-bottom: 15px;
        }
        .summary table {
            width: 50%;
        }
        .summary th {
            background-color: #FFC107;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .badge {
            padding: 3px 6px;
            border-radius: 3px;
            font-size: 9px;
        }
        .badge-success { background-color: #4CAF50; color: white; }
        .badge-warning { background-color: #FFC107; color: black; }
        .badge-info { background-color: #2196F3; color: white; }
        .badge-danger { background-color: #F44336; color: white; }
        .summary-box {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        .summary-box p {
            margin: 5px 0;
            font-size: 10px;
            padding: 3px 5px;
        }
        .summary-box p.header {
            font-weight: bold;
            font-size: 11px;
            background-color: #e0e0e0;
            padding: 5px;
        }
        h3 {
            margin-top: 20px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>LAPORAN SERVICE BERDASARKAN STATUS</h2>
        <p>Periode: {{Carbon\Carbon::parse($startDate)->format('d/m/Y')}} - {{Carbon\Carbon::parse($endDate)->format('d/m/Y')}}</p>
        <p>Cabang: {{$branchName}}</p>
    </div>

    <div class="summary-box">
        <p class="header">Ringkasan</p>
        <p>Total Service: {{$services->count()}}</p>
        <p>Selesai: {{$services->where('status', 'selesai')->count()}}</p>
        <p>Tertunda (> 3 hari): {{$services->filter(function($s) { return \Carbon\Carbon::parse($s->service_date)->diffInDays(\Carbon\Carbon::now()) > 3 && !in_array($s->status, ['selesai', 'dibatalkan']); })->count()}}</p>
        <p>Siap Diambil: {{$services->where('status', 'siap_diambil')->count()}}</p>
    </div>

    <div class="summary">
        <h3>Statistik Per Status</h3>
        <table>
            <thead>
                <tr>
                    <th>Status</th>
                    <th class="text-center">Jumlah</th>
                    <th class="text-right">Total Nilai</th>
                </tr>
            </thead>
            <tbody>
                @foreach($statusStats as $status => $stat)
                <tr>
                    <td>{{ucwords($status)}}</td>
                    <td class="text-center">{{$stat['count']}}</td>
                    <td class="text-right">Rp {{number_format($stat['total_value'], 0, ',', '.')}}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr style="font-weight: bold;">
                    <td>TOTAL</td>
                    <td class="text-center">{{$services->count()}}</td>
                    <td class="text-right">Rp {{number_format($services->sum('total_cost'), 0, ',', '.')}}</td>
                </tr>
            </tfoot>
        </table>
    </div>

    <h3>Detail Service</h3>
    <table>
        <thead>
            <tr>
                <th>No. Service</th>
                <th>Tanggal</th>
                <th>Customer</th>
                <th>Device</th>
                <th>Status</th>
                <th>Teknisi</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($services as $service)
            <tr>
                <td>{{$service->service_number}}</td>
                <td>{{$service->service_date->format('d/m/Y')}}</td>
                <td>{{$service->customer->name}}</td>
                <td>{{$service->device_brand}} {{$service->device_model}}</td>
                <td>{{ucwords($service->status)}}</td>
                <td>{{$service->technician->name ?? '-'}}</td>
                <td class="text-right">Rp {{number_format($service->total_cost, 0, ',', '.')}}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div style="margin-top: 30px; font-size: 9px; color: #666;">
        <p>Dicetak pada: {{now()->format('d/m/Y H:i:s')}}</p>
    </div>
</body>
</html>
