<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('service_number')->unique();
            $table->foreignId('customer_id')->constrained()->onDelete('cascade');
            $table->foreignId('branch_id')->constrained()->onDelete('cascade');
            $table->foreignId('technician_id')->nullable()->constrained('users')->onDelete('set null');
            $table->date('service_date');
            $table->string('device_type'); // HP, Tablet, dll
            $table->string('device_brand'); // Samsung, iPhone, dll
            $table->string('device_model'); // Galaxy S23, iPhone 14, dll
            $table->string('imei')->nullable();
            $table->text('complaint'); // Keluhan pelanggan
            $table->text('diagnosis')->nullable(); // Diagnosa teknisi
            $table->decimal('estimated_cost', 15, 2)->default(0);
            $table->decimal('service_fee', 15, 2)->default(0); // Biaya jasa
            $table->decimal('parts_cost', 15, 2)->default(0); // Total biaya spare part
            $table->decimal('total_cost', 15, 2)->default(0); // Total keseluruhan
            $table->decimal('down_payment', 15, 2)->default(0); // DP/Uang muka
            $table->decimal('remaining_payment', 15, 2)->default(0); // Sisa pembayaran
            $table->enum('status', [
                'menunggu diagnosa',
                'sedang diagnosa',
                'menunggu persetujuan',
                'menunggu spare part',
                'dalam pengerjaan',
                'quality control',
                'siap diambil',
                'selesai',
                'dibatalkan'
            ])->default('menunggu diagnosa');
            $table->enum('priority', ['normal', 'urgent', 'very urgent'])->default('normal');
            $table->dateTime('estimated_completion')->nullable();
            $table->dateTime('completed_at')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
