<?php

namespace App\Http\Controllers\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class CustomerController extends Controller
{
    public function __construct()
    {
        $this->middleware(['permission:customers.index'])->only('index');
        $this->middleware(['permission:customers.create'])->only('save');
        $this->middleware(['permission:customers.edit'])->only('update');
        $this->middleware(['permission:customers.delete'])->only('delete');
    }

    public function index()
    {
        $title = "customer";
        $customers = Customer::orderBy('id', 'desc')->get();

        return view('master.customer', compact('title','customers'));
    }

    public function save(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:customers',
            'email' => 'required|email|unique:users,email'
        ]);

        // Buat customer
        $customer = Customer::create([
            'name' => $request->input('name'),
            'phone' => $request->input('phone'),
            'address' => $request->input('address'),
            'email' => $request->input('email'),
        ]);

        if($customer){
            // Buat user akun otomatis untuk customer
            $defaultPassword = 'customer123'; // Password default

            $user = User::create([
                'name' => $customer->name,
                'email' => $customer->email,
                'password' => Hash::make($defaultPassword),
            ]);

            // Assign role customer ke user (jika ada role customer)
            if($user->hasRole('customer') == false) {
                $user->assignRole('customer');
            }

            // Update customer dengan user_id
            $customer->update(['user_id' => $user->id]);

            //redirect dengan pesan sukses
            return redirect()->route('customer')->with(['success' => 'Data Customer dan User Akun Berhasil Disimpan! Password default: ' . $defaultPassword]);
        }else{
            //redirect dengan pesan error
            return redirect()->route('customer')->with(['error' => 'Data Gagal Disimpan!']);
        }
    }

    public function update(Request $request, Customer $customer)
    {
        $this->validate($request, [
            'name' => 'required|unique:customers,name,'.$customer->id
        ]);

        $customer = Customer::findOrFail($customer->id);
        $customer->update([
            'name' => $request->input('name'),
            'phone' => $request->input('phone'),
            'address' => $request->input('address'),
            'email' => $request->input('email')
        ]);

        if($customer){
            //redirect dengan pesan sukses
            return redirect()->route('customer')->with(['success' => 'Data Berhasil Disimpan!']);
        }else{
            //redirect dengan pesan error
            return redirect()->route('customer')->with(['error' => 'Data Gagal Disimpan!']);
        }
    }

    public function delete(Customer $customer)
    {
        $customer->delete();

        return redirect()->route('customer')->with('success', 'Data Berhasil Dihapus');
    }

}

