<?php

namespace App\Http\Controllers\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Brand;

class BrandController extends Controller
{
    public function __construct()
    {
        $this->middleware(['permission:brands.index'])->only('index');
        $this->middleware(['permission:brands.create'])->only('save');
        $this->middleware(['permission:brands.edit'])->only('update');
        $this->middleware(['permission:brands.delete'])->only('delete');
    }

    public function index()
    {
        $title = "brand";
        $brands = Brand::orderBy('id', 'desc')->get();

        return view('master.brand', compact('title','brands'));
    }

    public function save(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:brands'
        ]);

        $brand = Brand::create([
            'name' => $request->input('name')
        ]);

        if($brand){
            //redirect dengan pesan sukses
            return redirect()->route('brand')->with(['success' => 'Data Berhasil Disimpan!']);
        }else{
            //redirect dengan pesan error
            return redirect()->route('brand')->with(['error' => 'Data Gagal Disimpan!']);
        }
    }

    public function update(Request $request, Brand $brand)
    {
        $this->validate($request, [
            'name' => 'required|unique:brands,name,'.$brand->id
        ]);

        $brand = Brand::findOrFail($brand->id);
        $brand->update([
            'name' => $request->input('name')
        ]);

        if($brand){
            //redirect dengan pesan sukses
            return redirect()->route('brand')->with(['success' => 'Data Berhasil Disimpan!']);
        }else{
            //redirect dengan pesan error
            return redirect()->route('brand')->with(['error' => 'Data Gagal Disimpan!']);
        }
    }

    public function delete(Brand $brand)
    {
        $brand->delete();

        return redirect()->route('brand')->with('success', 'Data Berhasil Dihapus');
    }

}
