<?php $__env->startSection('heading', 'Dashboard'); ?>



<?php $__env->startSection('content'); ?>

<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Dashboard</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Row 1: Produk yang Sudah Mencapai Batas Min Stok (CARD-12) -->
        <div class="row">
            <div class="col-12">
                <div class="card card-danger">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-exclamation-triangle"></i> Produk yang Sudah Mencapai Batas Minimum Stok</h3>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-striped table-sm">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Kode Produk</th>
                                    <th>Nama Produk</th>
                                    <th>Cabang</th>
                                    <th class="text-center">Stok Saat Ini</th>
                                    <th class="text-center">Stok Minimum</th>
                                    <th class="text-center">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $lowStockProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td>B-<?php echo e(str_pad($item->product->id, 4, '0', STR_PAD_LEFT)); ?></td>
                                        <td><?php echo e($item->product->name); ?></td>
                                        <td><?php echo e($item->branch->name ?? '-'); ?></td>
                                        <td class="text-center">
                                            <span class="badge badge-danger"><?php echo e(number_format($item->quantity)); ?> <?php echo e($item->product->unit); ?></span>
                                        </td>
                                        <td class="text-center"><?php echo e(number_format($item->product->min_stock)); ?> <?php echo e($item->product->unit); ?></td>
                                        <td class="text-center">
                                            <?php if($item->quantity == 0): ?>
                                                <span class="badge badge-dark">Habis</span>
                                            <?php elseif($item->quantity < $item->product->min_stock): ?>
                                                <span class="badge badge-danger">Di Bawah Minimum</span>
                                            <?php else: ?>
                                                <span class="badge badge-warning">Mencapai Minimum</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center">
                                            <div class="alert alert-success mb-0">
                                                <i class="fas fa-check-circle"></i> Semua produk masih aman, tidak ada yang mencapai batas minimum stok
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Row 2: Peringkat Produk Terlaris & Peringkat Customer (CARD-4 + CARD-4 + CARD-4) -->
        <div class="row">
            <!-- Peringkat Produk Terlaris -->
            <div class="col-md-6">
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-chart-line"></i> Peringkat Produk Terlaris</h3>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Produk</th>
                                    <th class="text-center">Terjual</th>
                                    <th class="text-right">Pendapatan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $topSellingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td>
                                            <strong><?php echo e($item->product->name); ?></strong><br>
                                            <small class="text-muted"><?php echo e($item->product->brand->name ?? '-'); ?></small>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge badge-success"><?php echo e(number_format($item->total_sold)); ?></span>
                                        </td>
                                        <td class="text-right">
                                            <small>Rp <?php echo e(number_format($item->total_revenue, 0, ',', '.')); ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted">Belum ada data penjualan</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Peringkat Customer -->
            <div class="col-md-6">
                <div class="card card-info">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-users"></i> Peringkat Customer</h3>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Customer</th>
                                    <th class="text-center">Transaksi</th>
                                    <th class="text-right">Total Belanja</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $topCustomers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td>
                                            <strong><?php echo e($item->customer->name ?? '-'); ?></strong><br>
                                            <small class="text-muted"><?php echo e($item->customer->phone ?? '-'); ?></small>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge badge-info"><?php echo e(number_format($item->total_transactions)); ?>x</span>
                                        </td>
                                        <td class="text-right">
                                            <small>Rp <?php echo e(number_format($item->total_spending, 0, ',', '.')); ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted">Belum ada data customer</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\laravel\resources\views/spatie/home.blade.php ENDPATH**/ ?>