<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>QR Code Produk</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            padding: 10mm;
        }

        .qr-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 5mm;
            width: 100%;
        }

        .qr-card {
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 8px;
            text-align: center;
            background-color: #fff;
            page-break-inside: avoid;
            height: 60mm;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .qr-code-wrapper {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 5px;
        }

        .qr-code-wrapper svg {
            max-width: 100%;
            max-height: 100%;
            width: auto;
            height: auto;
        }

        .qr-separator {
            border-top: 1px solid #ddd;
            margin: 5px 0;
        }

        .qr-text {
            font-weight: bold;
            font-size: 9pt;
            color: #333;
            padding: 5px;
            word-wrap: break-word;
            overflow-wrap: break-word;
        }

        /* Force page breaks after every 12 items (3 rows x 4 columns) */
        .qr-card:nth-child(12n) {
            page-break-after: always;
        }

        @page {
            size: A4 portrait;
            margin: 10mm;
        }

        @media print {
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="qr-grid">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="qr-card">
                <div class="qr-code-wrapper">
                    <?php echo generateQrCode($product->barcode, 120); ?>

                </div>
                <div class="qr-separator"></div>
                <div class="qr-text">
                    00<?php echo e($product->id); ?> - <?php echo e($product->name); ?>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</body>
</html>
<?php /**PATH C:\xampp82\htdocs\umi-cell\laravel\resources\views/product/qrcode-pdf.blade.php ENDPATH**/ ?>