@section('heading', 'Pergerakan Stok')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Histori Pergerakan Stok</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Pergerakan Stok</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Filter Data</h3>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="{{route('stock-movement')}}">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Produk</label>
                                        <select name="product_id" class="form-control">
                                            <option value="">-- Semua Produk --</option>
                                            @foreach($products as $product)
                                            <option value="{{$product->id}}" {{request('product_id') == $product->id ? 'selected' : ''}}>
                                                {{$product->name}}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Cabang</label>
                                        <select name="branch_id" class="form-control">
                                            <option value="">-- Semua Cabang --</option>
                                            @foreach($branches as $branch)
                                            <option value="{{$branch->id}}" {{request('branch_id') == $branch->id ? 'selected' : ''}}>
                                                {{$branch->name}}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Tipe</label>
                                        <select name="type" class="form-control">
                                            <option value="">-- Semua Tipe --</option>
                                            <option value="in" {{request('type') == 'in' ? 'selected' : ''}}>Masuk</option>
                                            <option value="out" {{request('type') == 'out' ? 'selected' : ''}}>Keluar</option>
                                            <option value="adjustment" {{request('type') == 'adjustment' ? 'selected' : ''}}>Penyesuaian</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Dari Tanggal</label>
                                        <input type="date" name="start_date" class="form-control" value="{{request('start_date')}}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Sampai Tanggal</label>
                                        <input type="date" name="end_date" class="form-control" value="{{request('end_date')}}">
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="submit" class="btn btn-primary btn-block">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Pergerakan Stok</h3>
                    </div>
                    <div class="card-body">
                        <table id="example1"  class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Tanggal</th>
                                    <th>Produk</th>
                                    <th>Cabang</th>
                                    <th>Tipe</th>
                                    <th>Qty</th>
                                    <th>Referensi</th>
                                    <th>Catatan</th>
                                    <th>User</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stockMovements as $index => $movement)
                                <tr>
                                    <td>{{$stockMovements->firstItem() + $index}}</td>
                                    <td>{{TanggalID($movement->created_at)}}</td>
                                    <td>{{$movement->product->name}}</td>
                                    <td>{{$movement->branch->name}}</td>
                                    <td>
                                        @if($movement->type == 'in')
                                        <span class="badge badge-success">Masuk</span>
                                        @elseif($movement->type == 'out')
                                        <span class="badge badge-danger">Keluar</span>
                                        @else
                                        <span class="badge badge-warning">Penyesuaian</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($movement->type == 'in')
                                        <span class="text-success">+{{number_format($movement->quantity, 0, ',', '.')}}</span>
                                        @elseif($movement->type == 'out')
                                        <span class="text-danger">-{{number_format($movement->quantity, 0, ',', '.')}}</span>
                                        @else
                                        {{number_format($movement->quantity, 0, ',', '.')}}
                                        @endif
                                    </td>
                                    <td>
                                        @if($movement->reference_type == 'App\Models\Purchase')
                                        <span class="badge badge-info">Pembelian</span>
                                        @elseif($movement->reference_type == 'App\Models\Sale')
                                        <span class="badge badge-primary">Penjualan</span>
                                        @elseif($movement->reference_type == 'App\Models\StockOpname')
                                        <span class="badge badge-warning">Stock Opname</span>
                                        @else
                                        -
                                        @endif
                                    </td>
                                    <td>{{$movement->notes ?? '-'}}</td>
                                    <td>{{$movement->user->name}}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">Tidak ada data</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer clearfix">
                        {{$stockMovements->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
