@section('heading', 'Detail Service')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Service</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{route('services.index')}}">Service</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif

        <div class="row">
            <div class="col-md-8">
                <!-- Informasi Perangkat -->
                <div class="card">
                    <div class="card-header bg-primary">
                        <h3 class="card-title">Informasi Perangkat</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 30%;">Jenis Perangkat</th>
                                <td>{{$service->device_type}}</td>
                            </tr>
                            <tr>
                                <th>Merek</th>
                                <td>{{$service->device_brand}}</td>
                            </tr>
                            <tr>
                                <th>Model</th>
                                <td>{{$service->device_model}}</td>
                            </tr>
                            @if($service->imei)
                            <tr>
                                <th>IMEI</th>
                                <td>{{$service->imei}}</td>
                            </tr>
                            @endif
                        </table>
                    </div>
                </div>

                <!-- Keluhan & Diagnosa -->
                <div class="card">
                    <div class="card-header bg-info">
                        <h3 class="card-title">Keluhan & Diagnosa</h3>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <strong>Keluhan Pelanggan:</strong>
                            <p>{{$service->complaint}}</p>
                        </div>
                        @if($service->diagnosis)
                        <div>
                            <strong>Diagnosa Teknisi:</strong>
                            <p>{{$service->diagnosis}}</p>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Spare Part -->
                <div class="card">
                    <div class="card-header bg-warning">
                        <h3 class="card-title">Spare Part Yang Digunakan</h3>
                    </div>
                    <div class="card-body">
                        @if($service->serviceDetails->count() > 0)
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Spare Part</th>
                                    <th style="width: 15%;">Qty</th>
                                    <th style="width: 20%;">Harga Satuan</th>
                                    <th style="width: 20%;">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($service->serviceDetails as $index => $detail)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$detail->product->name}}</td>
                                    <td>{{number_format($detail->quantity, 0, ',', '.')}}</td>
                                    <td class="text-right">Rp {{number_format($detail->unit_price, 0, ',', '.')}}</td>
                                    <td class="text-right">Rp {{number_format($detail->subtotal, 0, ',', '.')}}</td>
                                </tr>
                                @endforeach
                                <tr>
                                    <th colspan="4" class="text-right">Total Biaya Spare Part</th>
                                    <th class="text-right">Rp {{number_format($service->parts_cost, 0, ',', '.')}}</th>
                                </tr>
                            </tbody>
                        </table>
                        @else
                        <p class="text-muted text-center">Tidak ada spare part yang digunakan</p>
                        @endif
                    </div>
                </div>

                <!-- Riwayat Status -->
                <div class="card">
                    <div class="card-header bg-secondary">
                        <h3 class="card-title">Riwayat Status</h3>
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            @foreach($service->statusHistories->sortByDesc('created_at') as $history)
                            <div>
                                <i class="fas fa-circle bg-primary"></i>
                                <div class="timeline-item">
                                    <span class="time"><i class="fas fa-clock"></i> {{$history->created_at->format('d/m/Y H:i')}}</span>
                                    <h3 class="timeline-header">
                                        <strong>{{ucfirst($history->status)}}</strong>
                                    </h3>
                                    <div class="timeline-body">
                                        {{$history->notes}}
                                        <br><small class="text-muted">Oleh: {{$history->user->name}}</small>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- Informasi Service -->
                <div class="card">
                    <div class="card-header bg-success">
                        <h3 class="card-title">Informasi Service</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 40%;">No. Service</th>
                                <td>{{$service->service_number}}</td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td>{{TanggalID($service->service_date)}}</td>
                            </tr>
                            <tr>
                                <th>Customer</th>
                                <td>{{$service->customer->name}}</td>
                            </tr>
                            <tr>
                                <th>Cabang</th>
                                <td>{{$service->branch->name}}</td>
                            </tr>
                            <tr>
                                <th>Teknisi</th>
                                <td>{{$service->technician ? $service->technician->name : '-'}}</td>
                            </tr>
                            <tr>
                                <th>Prioritas</th>
                                <td>
                                    @if($service->priority == 'normal')
                                    <span class="badge badge-secondary">Normal</span>
                                    @elseif($service->priority == 'urgent')
                                    <span class="badge badge-warning">Urgent</span>
                                    @else
                                    <span class="badge badge-danger">Very Urgent</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($service->status == 'menunggu diagnosa')
                                    <span class="badge badge-secondary">Menunggu Diagnosa</span>
                                    @elseif($service->status == 'sedang diagnosa')
                                    <span class="badge badge-primary">Sedang Diagnosa</span>
                                    @elseif($service->status == 'menunggu persetujuan')
                                    <span class="badge badge-warning">Menunggu Persetujuan</span>
                                    @elseif($service->status == 'menunggu spare part')
                                    <span class="badge badge-warning">Menunggu Spare Part</span>
                                    @elseif($service->status == 'dalam pengerjaan')
                                    <span class="badge badge-info">Dalam Pengerjaan</span>
                                    @elseif($service->status == 'quality control')
                                    <span class="badge badge-purple">Quality Control</span>
                                    @elseif($service->status == 'siap diambil')
                                    <span class="badge badge-success">Siap Diambil</span>
                                    @elseif($service->status == 'selesai')
                                    <span class="badge badge-dark">Selesai</span>
                                    @else
                                    <span class="badge badge-danger">Dibatalkan</span>
                                    @endif
                                </td>
                            </tr>
                            @if($service->estimated_completion)
                            <tr>
                                <th>Est. Selesai</th>
                                <td>{{$service->estimated_completion->format('d/m/Y H:i')}}</td>
                            </tr>
                            @endif
                            @if($service->completed_at)
                            <tr>
                                <th>Selesai</th>
                                <td>{{$service->completed_at->format('d/m/Y H:i')}}</td>
                            </tr>
                            @endif
                        </table>

                        @if($service->notes)
                        <hr>
                        <strong>Catatan:</strong>
                        <p>{{$service->notes}}</p>
                        @endif
                    </div>
                </div>

                <!-- Biaya -->
                <div class="card">
                    <div class="card-header bg-warning">
                        <h3 class="card-title">Biaya Service</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th>Biaya Jasa</th>
                                <td class="text-right">Rp {{number_format($service->service_fee, 0, ',', '.')}}</td>
                            </tr>
                            <tr>
                                <th>Biaya Spare Part</th>
                                <td class="text-right">Rp {{number_format($service->parts_cost, 0, ',', '.')}}</td>
                            </tr>
                            <tr>
                                <th>Total Biaya</th>
                                <td class="text-right"><strong>Rp {{number_format($service->total_cost, 0, ',', '.')}}</strong></td>
                            </tr>
                            <tr>
                                <th>Uang Muka (DP)</th>
                                <td class="text-right">Rp {{number_format($service->down_payment, 0, ',', '.')}}</td>
                            </tr>
                            <tr>
                                <th>Sisa Pembayaran</th>
                                <td class="text-right text-danger"><strong>Rp {{number_format($service->remaining_payment, 0, ',', '.')}}</strong></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Update Status -->
                @can('services.edit')
                @if($service->status != 'selesai' && $service->status != 'dibatalkan')
                <div class="card">
                    <div class="card-header bg-info">
                        <h3 class="card-title">Update Status</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{route('services.update-status', $service->id)}}" method="POST">
                            @csrf
                            <div class="form-group">
                                <label>Status Baru</label>
                                <select name="status" class="form-control" required>
                                    <option value="">-- Pilih Status --</option>
                                    <option value="menunggu diagnosa">Menunggu Diagnosa</option>
                                    <option value="sedang diagnosa">Sedang Diagnosa</option>
                                    <option value="menunggu persetujuan">Menunggu Persetujuan</option>
                                    <option value="menunggu spare part">Menunggu Spare Part</option>
                                    <option value="dalam pengerjaan">Dalam Pengerjaan</option>
                                    <option value="quality control">Quality Control</option>
                                    <option value="siap diambil">Siap Diambil</option>
                                    <option value="selesai">Selesai</option>
                                    <option value="dibatalkan">Dibatalkan</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Catatan</label>
                                <textarea name="notes" class="form-control" rows="2" placeholder="Catatan perubahan status..."></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fas fa-sync"></i> Update Status
                            </button>
                        </form>
                    </div>
                </div>
                @endif
                @endcan

                <!-- Action Buttons -->
                <div class="card">
                    <div class="card-body">
                        <a href="{{route('services.print', $service->id)}}" class="btn btn-info btn-block" target="_blank">
                            <i class="fas fa-print"></i> Print Nota
                        </a>
                        @can('services.edit')
                        <a href="{{route('services.edit', $service->id)}}" class="btn btn-warning btn-block">
                            <i class="fas fa-edit"></i> Edit Service
                        </a>
                        @endcan
                        <a href="{{route('services.index')}}" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>

                <!-- QR Code Service -->
                @if($service->barcode)
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title"><i class="fas fa-qrcode"></i> QR Code Service</h3>
                    </div>
                    <div class="card-body text-center">
                        <div style="max-width: 300px; margin: 0 auto; border: 0px solid #007bff; border-radius: 10px; padding: 10px;">
                            {!! generateQrCode($service->barcode, 300) !!}
                        </div>
                        <div class="mt-3">
                            <p class="mb-2"><code style="font-size: 11px; background-color: #f8f9fa; padding: 5px 10px; border-radius: 3px;">{{$service->barcode}}</code></p>
                            <p class="text-muted mb-2"><small>Scan QR Code untuk melihat detail service</small></p>
                            <a href="{{ route('service.qrcode-jpg', $service->id) }}"
                               class="btn btn-success btn-sm">
                                <i class="fas fa-download"></i> Unduh QR Code (JPG)
                            </a>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>
@endsection

@section('styles')
<style>
.timeline {
    position: relative;
    margin: 0 0 30px 0;
    padding: 0;
    list-style: none;
}
.timeline:before {
    content: '';
    position: absolute;
    top: 0;
    bottom: 0;
    width: 4px;
    background: #ddd;
    left: 31px;
    margin: 0;
    border-radius: 2px;
}
.timeline>div {
    position: relative;
    margin-right: 10px;
    margin-bottom: 15px;
}
.timeline>div:before,
.timeline>div:after {
    content: " ";
    display: table;
}
.timeline>div>i {
    position: absolute;
    left: 18px;
    top: 0;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    text-align: center;
    line-height: 30px;
    font-size: 15px;
    background: #007bff;
    color: white;
}
.timeline>.timeline-item {
    margin-left: 60px;
    margin-right: 15px;
    background: #fff;
    color: #444;
    border: 1px solid #ddd;
    padding: 10px;
    border-radius: 3px;
    position: relative;
}
.timeline>.timeline-item>.time {
    color: #999;
    float: right;
    padding: 5px;
    font-size: 12px;
}
.timeline>.timeline-item>.timeline-header {
    margin: 0;
    color: #555;
    border-bottom: 1px solid #f4f4f4;
    padding: 5px;
    font-size: 16px;
    line-height: 1.1;
}
.timeline>.timeline-item>.timeline-body {
    padding: 10px;
}
.badge-purple {
    background-color: #6f42c1;
    color: white;
}
</style>
@endsection
