@section('heading', 'Laporan Pendapatan Service')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Laporan Pendapatan Service</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Laporan Service - Pendapatan </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Filter Form -->
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Filter Laporan</h3>
            </div>
            <div class="card-body">
                <form action="{{route('report.service.revenue')}}" method="GET">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Tanggal Mulai</label>
                                <input type="date" name="start_date" class="form-control" value="{{$startDate}}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Tanggal Akhir</label>
                                <input type="date" name="end_date" class="form-control" value="{{$endDate}}" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Cabang</label>
                                <select name="branch_id" class="form-control">
                                    <option value="">Semua Cabang</option>
                                    @foreach($branches as $branch)
                                    <option value="{{$branch->id}}" {{$branchId == $branch->id ? 'selected' : ''}}>
                                        {{$branch->name}}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Tampilkan
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <a href="{{route('report.service.revenue.export-pdf', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])}}" class="btn btn-danger" target="_blank">
                            <i class="fas fa-file-pdf"></i> Export PDF
                        </a>
                        <a href="{{route('report.service.revenue.export-excel', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])}}" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> Export Excel
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>Rp {{number_format($totalRevenue, 0, ',', '.')}}</h3>
                        <p>Total Pendapatan</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>Rp {{number_format($totalServiceFee, 0, ',', '.')}}</h3>
                        <p>Biaya Jasa Service</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-wrench"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>Rp {{number_format($totalPartsCost, 0, ',', '.')}}</h3>
                        <p>Biaya Spare Part</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-cog"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3>Rp {{number_format($totalRemaining, 0, ',', '.')}}</h3>
                        <p>Sisa Pembayaran</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-exclamation-circle"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="info-box bg-primary">
                    <span class="info-box-icon"><i class="fas fa-hand-holding-usd"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Down Payment (DP)</span>
                        <span class="info-box-number">Rp {{number_format($totalDownPayment, 0, ',', '.')}}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-success">
                    <span class="info-box-icon"><i class="fas fa-percentage"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Rata-rata DP</span>
                        <span class="info-box-number">
                            {{$totalRevenue > 0 ? number_format(($totalDownPayment / $totalRevenue) * 100, 1) : 0}}%
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-info">
                    <span class="info-box-icon"><i class="fas fa-calculator"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Rata-rata Nilai per Service</span>
                        <span class="info-box-number">
                            Rp {{$services->count() > 0 && $totalRevenue > 0 ? number_format($totalRevenue / $services->count(), 0, ',', '.') : 0}}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pendapatan per Cabang -->
        <div class="card">
            <div class="card-header bg-success">
                <h3 class="card-title">Pendapatan Per Cabang</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Cabang</th>
                            <th class="text-center">Jumlah Service</th>
                            <th class="text-right">Biaya Jasa</th>
                            <th class="text-right">Biaya Spare Part</th>
                            <th class="text-right">Total Pendapatan</th>
                            <th class="text-center">Persentase</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($branchRevenue as $revenue)
                        <tr>
                            <td><strong>{{$revenue['branch_name']}}</strong></td>
                            <td class="text-center">{{$revenue['total_services']}}</td>
                            <td class="text-right">Rp {{number_format($revenue['total_service_fee'], 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($revenue['total_parts_cost'], 0, ',', '.')}}</td>
                            <td class="text-right"><strong>Rp {{number_format($revenue['total_revenue'], 0, ',', '.')}}</strong></td>
                            <td class="text-center">
                                <span class="badge badge-primary">
                                    {{$totalRevenue > 0 ? number_format(($revenue['total_revenue'] / $totalRevenue) * 100, 1) : 0}}%
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="font-weight-bold bg-light">
                            <td>TOTAL</td>
                            <td class="text-center">{{$branchRevenue->sum('total_services')}}</td>
                            <td class="text-right">Rp {{number_format($totalServiceFee, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($totalPartsCost, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($totalRevenue, 0, ',', '.')}}</td>
                            <td class="text-center">100%</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Detail Transaksi -->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title">Detail Transaksi Service</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm" id="serviceTable">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Cabang</th>
                            <th class="text-right">Biaya Jasa</th>
                            <th class="text-right">Biaya Spare Part</th>
                            <th class="text-right">Total</th>
                            <th class="text-right">DP</th>
                            <th class="text-right">Sisa</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($services as $service)
                        <tr>
                            <td><a href="{{route('services.show', $service->id)}}">{{$service->service_number}}</a></td>
                            <td>{{$service->service_date->format('d/m/Y')}}</td>
                            <td>{{$service->customer->name}}</td>
                            <td>{{$service->device_brand}} {{$service->device_model}}</td>
                            <td>{{$service->branch->name}}</td>
                            <td class="text-right">Rp {{number_format($service->service_fee, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($service->parts_cost, 0, ',', '.')}}</td>
                            <td class="text-right"><strong>Rp {{number_format($service->total_cost, 0, ',', '.')}}</strong></td>
                            <td class="text-right">Rp {{number_format($service->down_payment, 0, ',', '.')}}</td>
                            <td class="text-right">
                                <span class="{{$service->remaining_payment > 0 ? 'text-danger' : 'text-success'}}">
                                    Rp {{number_format($service->remaining_payment, 0, ',', '.')}}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="font-weight-bold">
                            <td colspan="5" class="text-right">TOTAL:</td>
                            <td class="text-right">Rp {{number_format($totalServiceFee, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($totalPartsCost, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($totalRevenue, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($totalDownPayment, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($totalRemaining, 0, ',', '.')}}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#serviceTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[1, 'desc']]
    });
});
</script>
@endpush
