@section('heading', 'Produk')

@extends('layouts.app')

@section('content')


<style>
    .warning {
        background-color: yellow;
    }

</style>


<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1> Produk </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{route('home')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active"> Produk </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"> <b>Produk</b> </h3>
                        <div class="card-tools">
                            @can('products.index')
                                <a href="{{route('product.download-products-list-pdf')}}" target="_blank" class="btn btn-danger text-white btn-sm m-1" title="Download Daftar Produk PDF">
                                    <i class="fas fa-file-pdf"></i> Download Daftar Produk PDF
                                </a>
                            @endcan
                            @can('products.create')
                                <button type="button" class="btn btn-info text-white btn-sm m-1" title="Scan QR Code" data-toggle="modal" data-target="#scanQrCodeModal">
                                    <i class="fas fa-qrcode"></i> Scan QR Code
                                </button>
                                <button type="button" class="btn btn-primary text-white btn-sm m-1" title="Import Excel" data-toggle="modal" data-target="#modal-import">
                                    <i class="fas fa-file-excel"></i> Import Excel
                                </button>
                                <button type="button" class="btn btn-success text-white btn-sm m-1" title="Tambah" data-toggle="modal" data-target="#modal-tambah">
                                    <i class="fas fa-plus-circle"></i> Tambah
                                </button>
                                <div class="modal fade" id="modal-tambah">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title"> Tambah Produk </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="{{ route('product.save') }}" method="POST" enctype="multipart/form-data" id="form-tambah-product" novalidate>
                                                @csrf
                                                <div class="modal-body">
                                                    <!-- Nav Tabs -->
                                                    <ul class="nav nav-tabs" id="productTab" role="tablist">
                                                        <li class="nav-item">
                                                            <a class="nav-link active" id="data-tab" data-toggle="tab" href="#data-produk" role="tab">
                                                                <i class="fas fa-box"></i> Data Produk <span class="text-danger">*</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" id="stok-tab" data-toggle="tab" href="#stok-produk" role="tab">
                                                                <i class="fas fa-warehouse"></i> Stok per Cabang <span class="text-danger">*</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" id="harga-tab" data-toggle="tab" href="#harga-produk" role="tab">
                                                                <i class="fas fa-tags"></i> Harga per Cabang <span class="text-danger">*</span>
                                                            </a>
                                                        </li>
                                                    </ul>

                                                    <!-- Tab Content -->
                                                    <div class="tab-content" id="productTabContent" style="padding-top: 15px;">
                                                        <!-- Tab 1: Data Produk -->
                                                        <div class="tab-pane fade show active" id="data-produk" role="tabpanel">
                                                            <div class="form-group">
                                                                <label> Produk <span class="text-danger">*</span></label>
                                                                <input type="text" name="name" value="{{ old('name') }}" placeholder="Masukkan Produk" class="form-control @error('name') is-invalid @enderror" required>
                                                                @error('name')
                                                                <div class="invalid-feedback" style="display: block">
                                                                    {{ $message }}
                                                                </div>
                                                                @enderror
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Kategori <span class="text-danger">*</span></label>
                                                                <select name="category_id" class="form-control select2 @error('category_id') is-invalid @enderror" required>
                                                                    <option value="">Pilih Kategori</option>
                                                                    @foreach($categories as $category)
                                                                        <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                                            {{ $category->name }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                @error('category_id')
                                                                <div class="invalid-feedback" style="display: block">
                                                                    {{ $message }}
                                                                </div>
                                                                @enderror
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Merek <span class="text-danger">*</span></label>
                                                                <select name="brand_id" class="form-control select2 @error('brand_id') is-invalid @enderror" required>
                                                                    <option value="">Pilih Merek</option>
                                                                    @foreach($brands as $brand)
                                                                        <option value="{{ $brand->id }}" {{ old('brand_id') == $brand->id ? 'selected' : '' }}>
                                                                            {{ $brand->name }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                @error('brand_id')
                                                                <div class="invalid-feedback" style="display: block">
                                                                    {{ $message }}
                                                                </div>
                                                                @enderror
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Satuan Unit <span class="text-danger">*</span></label>
                                                                <input type="text" name="unit" value="{{ old('unit') }}" placeholder="Contoh: pcs, box, unit" class="form-control @error('unit') is-invalid @enderror" required>
                                                                @error('unit')
                                                                <div class="invalid-feedback" style="display: block">
                                                                    {{ $message }}
                                                                </div>
                                                                @enderror
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Minimal Stok <span class="text-danger">*</span></label>
                                                                <input type="number" name="min_stock" value="{{ old('min_stock') }}" placeholder="Masukkan minimal stok" class="form-control @error('min_stock') is-invalid @enderror" required>
                                                                @error('min_stock')
                                                                <div class="invalid-feedback" style="display: block">
                                                                    {{ $message }}
                                                                </div>
                                                                @enderror
                                                            </div>
                                                            <div class="form-group">
                                                                <label> Deskripsi </label>
                                                                <textarea name="description" placeholder="Masukkan Deskripsi" class="form-control @error('description') is-invalid @enderror">{{ old('description') }}</textarea>
                                                                @error('description')
                                                                <div class="invalid-feedback" style="display: block">
                                                                    {{ $message }}
                                                                </div>
                                                                @enderror
                                                            </div>
                                                        </div>

                                                        <!-- Tab 2: Stok per Cabang -->
                                                        <div class="tab-pane fade" id="stok-produk" role="tabpanel">
                                                            <div class="alert alert-info">
                                                                <i class="icon fas fa-info-circle"></i>
                                                                Pilih cabang dan atur stok awal produk
                                                            </div>
                                                            <button type="button" class="btn btn-sm btn-success mb-3" id="btn-add-stock">
                                                                <i class="fas fa-plus"></i> Tambah Stok Cabang
                                                            </button>
                                                            <div id="stok-container"></div>
                                                        </div>

                                                        <!-- Tab 3: Harga per Cabang -->
                                                        <div class="tab-pane fade" id="harga-produk" role="tabpanel">
                                                            <div class="alert alert-info">
                                                                <i class="icon fas fa-info-circle"></i>
                                                                Pilih cabang dan atur harga beli & jual
                                                            </div>
                                                            <button type="button" class="btn btn-sm btn-success mb-3" id="btn-add-price">
                                                                <i class="fas fa-plus"></i> Tambah Harga Cabang
                                                            </button>
                                                            <div id="harga-container"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary btn-submit">
                                                        <i class="fa fa-paper-plane"></i> Simpan Semua
                                                    </button>
                                                    <button class="btn btn-warning text-white btn-reset" type="reset">
                                                        <i class="fa fa-redo"></i> Reset
                                                    </button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                                        <i class="fas fa-undo"></i> Kembali
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                             @endcan
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Search Filter -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-search"></i> Pencarian Produk</label>
                                    <select id="searchProduct" class="form-control select2-search">
                                        <option value="">Cari berdasarkan ID atau Nama Produk...</option>
                                        @foreach($products as $product)
                                            <option value="{{$product->id}}">00{{$product->id}} - {{$product->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><i class="fas fa-filter"></i> Filter Kategori</label>
                                    <select id="filterCategory" class="form-control select2-filter">
                                        <option value="">Semua Kategori</option>
                                        @foreach($categories as $category)
                                            <option value="{{$category->name}}">{{$category->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><i class="fas fa-filter"></i> Filter Merek</label>
                                    <select id="filterBrand" class="form-control select2-filter">
                                        <option value="">Semua Merek</option>
                                        @foreach($brands as $brand)
                                            <option value="{{$brand->name}}">{{$brand->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Filter Tanggal -->
                        <form action="{{ route('product') }}" method="GET">
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><i class="fas fa-calendar"></i> Dari Tanggal</label>
                                        <input type="date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><i class="fas fa-calendar"></i> Sampai Tanggal</label>
                                        <input type="date" name="to_date" class="form-control" value="{{ request('to_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div>
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-filter"></i> Filter
                                            </button>
                                            <a href="{{ route('product') }}" class="btn btn-secondary">
                                                <i class="fas fa-redo"></i> Reset
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th scope="col" style="text-align: center;width: 6%">NO.</th>
                                    <th scope="col">Kode</th>
                                    <th scope="col">Produk</th>
                                    <th scope="col">Kategori</th>
                                    <th scope="col">Merek</th>
                                    {{-- <th scope="col">QR Code</th> --}}
                                    <th scope="col">Min Stock</th>
                                    <th scope="col">Total Stock</th>
                                    <th scope="col">Harga Jual</th>
                                    <th scope="col">Harga Beli</th>
                                    <th scope="col">Waktu</th>
                                    <th scope="col" style="width: 15%;text-align: center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nomer = 1; ?>
                                @foreach ($products as $no => $product)
                                <tr>
                                    <th>{{ $nomer++}}</th>
                                    <td>00{{ $product->id }}</td>
                                    <td>{{ $product->name }}</td>
                                    <td>{{ $product->category->name ?? 'N/A' }}</td>
                                    <td>{{ $product->brand->name ?? 'N/A' }}</td>
                                    {{-- <td style="text-align: center;">
                                        <div style="display: inline-block; border: 2px solid #ddd; padding: 10px; border-radius: 8px; background-color: #fff;">
                                            {!! generateQrCode($product->barcode, 100) !!}
                                            <div style="margin-top: 8px; font-weight: bold; font-size: 11px; color: #333; border-top: 1px solid #ddd; padding-top: 8px;">
                                                00{{ $product->id }} - {{ $product->name }}
                                            </div>
                                        </div>
                                    </td> --}}
                                    <td>{{ $product->min_stock }}</td>
                                    <td>{{ $product->productStocks->sum('quantity') ?? 0 }}</td>
                                    <td>
                                        {{ number_format(optional($product->productPrices->first())->purchase_price ?? 0, 0, ',', '.') }}
                                    </td>
                                    <td>
                                        {{ number_format(optional($product->productPrices->first())->selling_price ?? 0, 0, ',', '.') }}
                                    </td>
                                    <td>{{ $product->created_at->translatedFormat('j F Y') }}</td>
                                    <td class="text-left">
                                        @can('products.index')
                                            <a href="{{route('product.show', $product->id)}}" class="btn btn-info btn-sm m-1" title="Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        @endcan

                                        @can('products.edit')
                                            <button type="button" class="btn btn-warning text-white btn-sm m-1" title="Edit" data-toggle="modal" data-target="#modal-edit-{{ $product->id }}">
                                                <i class="fas fa-pencil-alt"></i>
                                            </button>
                                            <div class="modal fade" id="modal-edit-{{ $product->id }}">
                                                <div class="modal-dialog modal-xl">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"> Edit Produk: {{ $product->name }} </h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('product.update', $product->id) }}" method="POST" enctype="multipart/form-data" class="form-edit-product" id="form-edit-product-{{ $product->id }}" novalidate data-product-id="{{ $product->id }}">
                                                            @csrf
                                                            @method('PUT')
                                                            <div class="modal-body">
                                                                <!-- Nav Tabs -->
                                                                <ul class="nav nav-tabs" id="editProductTab{{ $product->id }}" role="tablist">
                                                                    <li class="nav-item">
                                                                        <a class="nav-link active" id="edit-data-tab-{{ $product->id }}" data-toggle="tab" href="#edit-data-produk-{{ $product->id }}" role="tab">
                                                                            <i class="fas fa-box"></i> Data Produk
                                                                        </a>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <a class="nav-link" id="edit-stok-tab-{{ $product->id }}" data-toggle="tab" href="#edit-stok-produk-{{ $product->id }}" role="tab">
                                                                            <i class="fas fa-warehouse"></i> Stok per Cabang
                                                                        </a>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <a class="nav-link" id="edit-harga-tab-{{ $product->id }}" data-toggle="tab" href="#edit-harga-produk-{{ $product->id }}" role="tab">
                                                                            <i class="fas fa-tags"></i> Harga per Cabang
                                                                        </a>
                                                                    </li>
                                                                </ul>

                                                                <!-- Tab Content -->
                                                                <div class="tab-content" id="editProductTabContent{{ $product->id }}" style="padding-top: 15px;">
                                                                    <!-- Tab 1: Data Produk -->
                                                                    <div class="tab-pane fade show active" id="edit-data-produk-{{ $product->id }}" role="tabpanel">
                                                                        <div class="form-group">
                                                                            <label> Produk <span class="text-danger">*</span></label>
                                                                            <input type="text" name="name" value="{{ old('name', $product->name) }}" placeholder="Masukkan Produk" class="form-control @error('name') is-invalid @enderror" required>
                                                                            @error('name')
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                {{ $message }}
                                                                            </div>
                                                                            @enderror
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Kategori <span class="text-danger">*</span></label>
                                                                            <select name="category_id" class="form-control select2-edit @error('category_id') is-invalid @enderror" data-original-value="{{ $product->category_id }}" required>
                                                                                <option value="">Pilih Kategori</option>
                                                                                @foreach($categories as $category)
                                                                                    <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>
                                                                                        {{ $category->name }}
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                            @error('category_id')
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                {{ $message }}
                                                                            </div>
                                                                            @enderror
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Merek <span class="text-danger">*</span></label>
                                                                            <select name="brand_id" class="form-control select2-edit @error('brand_id') is-invalid @enderror" data-original-value="{{ $product->brand_id }}" required>
                                                                                <option value="">Pilih Merek</option>
                                                                                @foreach($brands as $brand)
                                                                                    <option value="{{ $brand->id }}" {{ old('brand_id', $product->brand_id) == $brand->id ? 'selected' : '' }}>
                                                                                        {{ $brand->name }}
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                            @error('brand_id')
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                {{ $message }}
                                                                            </div>
                                                                            @enderror
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Satuan Unit <span class="text-danger">*</span></label>
                                                                            <input type="text" name="unit" value="{{ old('unit', $product->unit) }}" placeholder="Contoh: pcs, box, unit" class="form-control @error('unit') is-invalid @enderror" required>
                                                                            @error('unit')
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                {{ $message }}
                                                                            </div>
                                                                            @enderror
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Minimal Stok <span class="text-danger">*</span></label>
                                                                            <input type="number" name="min_stock" value="{{ old('min_stock', $product->min_stock) }}" placeholder="Masukkan minimal stok" class="form-control @error('min_stock') is-invalid @enderror" required>
                                                                            @error('min_stock')
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                {{ $message }}
                                                                            </div>
                                                                            @enderror
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label> Deskripsi </label>
                                                                            <textarea name="description" placeholder="Masukkan Deskripsi" class="form-control @error('description') is-invalid @enderror">{{ old('description', $product->description) }}</textarea>
                                                                            @error('description')
                                                                            <div class="invalid-feedback" style="display: block">
                                                                                {{ $message }}
                                                                            </div>
                                                                            @enderror
                                                                        </div>
                                                                    </div>

                                                                    <!-- Tab 2: Stok per Cabang -->
                                                                    <div class="tab-pane fade" id="edit-stok-produk-{{ $product->id }}" role="tabpanel">
                                                                        <div class="alert alert-info">
                                                                            <i class="icon fas fa-info-circle"></i>
                                                                            Kelola stok produk per cabang. Anda dapat menambah cabang baru atau mengubah stok yang sudah ada.
                                                                        </div>
                                                                        <button type="button" class="btn btn-sm btn-success mb-3 btn-add-stock-edit" data-product-id="{{ $product->id }}">
                                                                            <i class="fas fa-plus"></i> Tambah Stok Cabang
                                                                        </button>
                                                                        <div id="stok-container-{{ $product->id }}">
                                                                            @foreach($product->productStocks as $index => $stock)
                                                                            <div class="card mb-3" id="stock-edit-{{ $product->id }}-{{ $index }}" data-original-stock-id="{{ $stock->id }}">
                                                                                <div class="card-body">
                                                                                    <div class="row">
                                                                                        <div class="col-md-6">
                                                                                            <div class="form-group">
                                                                                                <label>Cabang <span class="text-danger">*</span></label>
                                                                                                <select name="stocks[{{ $index }}][branch_id]" class="form-control stock-branch-select-edit" data-stock-id="stock-edit-{{ $product->id }}-{{ $index }}" data-product-id="{{ $product->id }}" required>
                                                                                                    <option value="">Pilih Cabang</option>
                                                                                                    @foreach($branches as $branch)
                                                                                                        <option value="{{ $branch->id }}" {{ $stock->branch_id == $branch->id ? 'selected' : '' }}>
                                                                                                            {{ $branch->name }}
                                                                                                        </option>
                                                                                                    @endforeach
                                                                                                </select>
                                                                                                <input type="hidden" name="stocks[{{ $index }}][id]" value="{{ $stock->id }}">
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-5">
                                                                                            <div class="form-group">
                                                                                                <label>Jumlah Stok <span class="text-danger">*</span></label>
                                                                                                <input type="number" name="stocks[{{ $index }}][quantity]" value="{{ $stock->quantity }}"
                                                                                                    class="form-control" placeholder="0" min="0" required>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-1">
                                                                                            <label>&nbsp;</label>
                                                                                            <button type="button" class="btn btn-danger btn-block btn-remove-stock-edit" data-stock-id="stock-edit-{{ $product->id }}-{{ $index }}" data-product-id="{{ $product->id }}">
                                                                                                <i class="fas fa-trash"></i>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>

                                                                    <!-- Tab 3: Harga per Cabang -->
                                                                    <div class="tab-pane fade" id="edit-harga-produk-{{ $product->id }}" role="tabpanel">
                                                                        <div class="alert alert-info">
                                                                            <i class="icon fas fa-info-circle"></i>
                                                                            Kelola harga produk per cabang. Anda dapat menambah cabang baru atau mengubah harga yang sudah ada.
                                                                        </div>
                                                                        <button type="button" class="btn btn-sm btn-success mb-3 btn-add-price-edit" data-product-id="{{ $product->id }}">
                                                                            <i class="fas fa-plus"></i> Tambah Harga Cabang
                                                                        </button>
                                                                        <div id="harga-container-{{ $product->id }}">
                                                                            @foreach($product->productPrices as $index => $price)
                                                                            <div class="card mb-3" id="price-edit-{{ $product->id }}-{{ $index }}" data-original-price-id="{{ $price->id }}">
                                                                                <div class="card-body">
                                                                                    <div class="row">
                                                                                        <div class="col-md-4">
                                                                                            <div class="form-group">
                                                                                                <label>Cabang <span class="text-danger">*</span></label>
                                                                                                <select name="prices[{{ $index }}][branch_id]" class="form-control price-branch-select-edit" data-price-id="price-edit-{{ $product->id }}-{{ $index }}" data-product-id="{{ $product->id }}" required>
                                                                                                    <option value="">Pilih Cabang</option>
                                                                                                    @foreach($branches as $branch)
                                                                                                        <option value="{{ $branch->id }}" {{ $price->branch_id == $branch->id ? 'selected' : '' }}>
                                                                                                            {{ $branch->name }}
                                                                                                        </option>
                                                                                                    @endforeach
                                                                                                </select>
                                                                                                <input type="hidden" name="prices[{{ $index }}][id]" value="{{ $price->id }}">
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-3">
                                                                                            <div class="form-group">
                                                                                                <label>Harga Beli <span class="text-danger">*</span></label>
                                                                                                <input type="number" name="prices[{{ $index }}][purchase_price]" value="{{ $price->purchase_price }}"
                                                                                                    class="form-control" placeholder="0" min="0" step="0.01" required>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-3">
                                                                                            <div class="form-group">
                                                                                                <label>Harga Jual <span class="text-danger">*</span></label>
                                                                                                <input type="number" name="prices[{{ $index }}][selling_price]" value="{{ $price->selling_price }}"
                                                                                                    class="form-control" placeholder="0" min="0" step="0.01" required>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="col-md-2">
                                                                                            <label>&nbsp;</label>
                                                                                            <button type="button" class="btn btn-danger btn-block btn-remove-price-edit" data-price-id="price-edit-{{ $product->id }}-{{ $index }}" data-product-id="{{ $product->id }}">
                                                                                                <i class="fas fa-trash"></i>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-primary btn-submit-edit">
                                                                    <i class="fa fa-paper-plane"></i> Simpan Semua
                                                                </button>
                                                                <button class="btn btn-warning text-white btn-reset" type="reset">
                                                                    <i class="fa fa-redo"></i> Reset
                                                                </button>
                                                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                                                    <i class="fas fa-undo"></i> Kembali
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endcan
                                        @can('products.delete')
                                            <form action="{{ route('product.delete', $product->id) }}" method="POST" style="display:inline;" class="delete-form-{{ $product->id }}">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" class="btn btn-danger btn-sm delete m-1" data-id="{{ $product->id}}" data-name="{{ $product->name}}" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->

<!-- Modal Import Excel -->
<div class="modal fade" id="modal-import">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Import Produk dari Excel</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('product.import-excel') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>Petunjuk:</strong>
                        <ol class="mb-0 pl-3">
                            <li>Download template Excel terlebih dahulu</li>
                            <li>Isi data produk sesuai format template</li>
                            <li>Upload file Excel yang sudah diisi</li>
                            <li>Pastikan Kategori, Merek, dan Cabang sudah ada di sistem</li>
                        </ol>
                    </div>

                    <div class="form-group">
                        <label>Download Template</label>
                        <div>
                            <a href="{{ route('product.download-template') }}" class="btn btn-success btn-sm" target="_blank">
                                <i class="fas fa-download"></i> Download Template Excel
                            </a>
                        </div>
                        <small class="text-muted">Template berisi format dan contoh data yang benar</small>
                    </div>

                    <hr>

                    <div class="form-group">
                        <label for="excel_file">Upload File Excel <span class="text-danger">*</span></label>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="excel_file" name="excel_file" accept=".xlsx,.xls" required>
                            <label class="custom-file-label" for="excel_file">Pilih file...</label>
                        </div>
                        <small class="text-muted">Format: .xlsx atau .xls (Maksimal 2MB)</small>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Upload & Import
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Scan QR Code -->
<div class="modal fade" id="scanQrCodeModal" tabindex="-1" role="dialog" aria-labelledby="scanQrModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title" id="scanQrModalLabel">
                    <i class="fas fa-qrcode"></i> Scan QR Code Produk
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Tab Navigation -->
                <ul class="nav nav-tabs mb-3" id="scanTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="manual-scan-tab" data-toggle="tab" href="#manualScan" role="tab">
                            <i class="fas fa-keyboard"></i> Input Manual
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="camera-scan-tab" data-toggle="tab" href="#cameraScan" role="tab">
                            <i class="fas fa-camera"></i> Scan dengan Kamera
                        </a>
                    </li>
                </ul>

                <!-- Tab Content -->
                <div class="tab-content" id="scanTabContent">
                    <!-- Manual Input Tab -->
                    <div class="tab-pane fade show active" id="manualScan" role="tabpanel">
                        <div class="form-group">
                            <label><i class="fas fa-qrcode"></i> Scan atau Ketik QR Code Produk</label>
                            <input type="text" id="barcodeInputIndex" class="form-control form-control-lg"
                                placeholder="Scan QR Code atau ketik QR Code produk..." autofocus>
                            <small class="form-text text-muted">
                                <i class="fas fa-info-circle"></i> Gunakan QR Code scanner atau ketik QR Code produk, tekan Enter untuk mencari
                            </small>
                        </div>
                    </div>

                    <!-- Camera Scan Tab -->
                    <div class="tab-pane fade" id="cameraScan" role="tabpanel">
                        <div class="text-center mb-3">
                            <button type="button" id="startCameraBtnIndex" class="btn btn-success btn-lg">
                                <i class="fas fa-camera"></i> Aktifkan Kamera untuk Scan QR Code
                            </button>
                            <button type="button" id="stopCameraBtnIndex" class="btn btn-danger btn-lg" style="display: none;">
                                <i class="fas fa-stop"></i> Matikan Kamera
                            </button>
                        </div>
                        <div id="qr-reader-index" style="display: none; width: 100%; max-width: 600px; margin: 0 auto;"></div>
                        <div id="qr-reader-results-index" class="mt-2"></div>
                    </div>
                </div>

                <!-- Product Result -->
                <div id="productResult" class="mt-3" style="display: none;">
                    <div class="alert alert-success">
                        <h5><i class="fas fa-check-circle"></i> Produk Ditemukan!</h5>
                        <div id="productInfo"></div>
                        <div class="mt-3">
                            <button type="button" class="btn btn-primary" id="goToDetailBtn">
                                <i class="fas fa-eye"></i> Lihat Detail Produk
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Not Found Result -->
                <div id="notFoundResult" class="mt-3" style="display: none;">
                    <div class="alert alert-danger">
                        <h5><i class="fas fa-times-circle"></i> Produk Tidak Ditemukan</h5>
                        <p class="mb-0">QR Code yang di-scan tidak terdaftar di sistem.</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i> Tutup
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<!-- HTML5 QR Code Scanner Library -->
<script src="https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js"></script>
<script>
let html5QrCodeIndex = null;

// QR Code Scanning Functions
$(document).ready(function() {
    // Reset modal when opened
    $('#scanQrCodeModal').on('shown.bs.modal', function () {
        $('#barcodeInputIndex').focus();
        $('#productResult').hide();
        $('#notFoundResult').hide();
        $('#barcodeInputIndex').val('');
    });

    // Reset camera when modal closed
    $('#scanQrCodeModal').on('hidden.bs.modal', function () {
        stopQrScannerIndex();
        $('#productResult').hide();
        $('#notFoundResult').hide();
        $('#barcodeInputIndex').val('');
    });

    // Manual barcode input handler
    $('#barcodeInputIndex').on('keypress', function(e) {
        if (e.which === 13) { // Enter key pressed
            e.preventDefault();
            const barcode = $(this).val().trim();

            if (!barcode) {
                alert('Masukkan QR Code produk!');
                return;
            }

            // Find product by barcode
            findProductByBarcodeIndex(barcode);
        }
    });

    // Auto focus to barcode input when manual tab is active
    $('#manual-scan-tab').on('click', function() {
        setTimeout(function() {
            $('#barcodeInputIndex').focus();
        }, 100);
    });

    // Start camera button
    $('#startCameraBtnIndex').on('click', function() {
        startQrScannerIndex();
    });

    // Stop camera button
    $('#stopCameraBtnIndex').on('click', function() {
        stopQrScannerIndex();
    });

    // When leaving camera tab, stop camera
    $('#manual-scan-tab').on('click', function() {
        stopQrScannerIndex();
    });
});

function startQrScannerIndex() {
    // Show camera preview
    $('#qr-reader-index').show();
    $('#startCameraBtnIndex').hide();
    $('#stopCameraBtnIndex').show();

    // Initialize QR Code scanner
    html5QrCodeIndex = new Html5Qrcode("qr-reader-index");

    const config = {
        fps: 10,
        qrbox: { width: 250, height: 250 }
    };

    html5QrCodeIndex.start(
        { facingMode: "environment" }, // Use back camera
        config,
        (decodedText, decodedResult) => {
            // QR Code successfully scanned
            console.log(`QR Code detected: ${decodedText}`);

            // Process the scanned barcode
            findProductByBarcodeIndex(decodedText);

            // Stop scanner after successful scan
            stopQrScannerIndex();
        },
        (errorMessage) => {
            // Scan error (can be ignored, happens during scanning)
        }
    ).catch((err) => {
        console.error('Error starting QR scanner:', err);
        alert('Gagal mengaktifkan kamera. Pastikan Anda memberikan izin akses kamera.');
        stopQrScannerIndex();
    });
}

function stopQrScannerIndex() {
    if (html5QrCodeIndex) {
        html5QrCodeIndex.stop().then(() => {
            html5QrCodeIndex.clear();
            html5QrCodeIndex = null;
            $('#qr-reader-index').hide();
            $('#startCameraBtnIndex').show();
            $('#stopCameraBtnIndex').hide();
        }).catch((err) => {
            console.error('Error stopping QR scanner:', err);
            $('#qr-reader-index').hide();
            $('#startCameraBtnIndex').show();
            $('#stopCameraBtnIndex').hide();
        });
    } else {
        $('#qr-reader-index').hide();
        $('#startCameraBtnIndex').show();
        $('#stopCameraBtnIndex').hide();
    }
}

function findProductByBarcodeIndex(barcode) {
    // Show loading
    $('#productResult').hide();
    $('#notFoundResult').hide();

    $.ajax({
        url: '{{ route("product.find-product-by-barcode") }}',
        method: 'GET',
        data: { barcode: barcode },
        success: function(response) {
            if (response.success && response.product) {
                const product = response.product;

                // Display product info
                const productHtml = `
                    <table class="table table-sm table-bordered">
                        <tr>
                            <th style="width: 30%;">Nama Produk</th>
                            <td><strong>${product.name}</strong></td>
                        </tr>
                        <tr>
                            <th>QR Code</th>
                            <td><code>${product.barcode}</code></td>
                        </tr>
                        <tr>
                            <th>Kategori</th>
                            <td>${product.category}</td>
                        </tr>
                        <tr>
                            <th>Merek</th>
                            <td>${product.brand}</td>
                        </tr>
                        <tr>
                            <th>Satuan</th>
                            <td>${product.unit}</td>
                        </tr>
                        <tr>
                            <th>Deskripsi</th>
                            <td>${product.description || '-'}</td>
                        </tr>
                    </table>
                `;

                $('#productInfo').html(productHtml);
                $('#productResult').show();

                // Set button to redirect to product show page
                $('#goToDetailBtn').off('click').on('click', function() {
                    // Redirect to product show page
                    window.location.href = '{{ url("admin/product") }}/' + product.id;
                });

            } else {
                $('#notFoundResult').show();
            }
        },
        error: function(xhr) {
            $('#notFoundResult').show();
            console.error('Error finding product:', xhr);
        }
    });
}
</script>

<script>
$(document).ready(function() {
    // Data cabang dari controller
    var branches = @json($branches);
    var selectedStockBranches = []; // Track cabang yang sudah dipilih untuk stok
    var selectedPriceBranches = []; // Track cabang yang sudah dipilih untuk harga
    var stockCounter = 0;
    var priceCounter = 0;

    // Disable tombol submit saat modal pertama kali dibuka
    $('#modal-tambah').on('shown.bs.modal', function () {
        $('#form-tambah-product .btn-submit').prop('disabled', true);
    });

    // Handle tab change - enable submit hanya di tab Harga per Cabang (Form Tambah)
    $('#productTab a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var targetTab = $(e.target).attr('href');

        if (targetTab === '#harga-produk') {
            // Tab Harga per Cabang aktif - enable tombol submit
            $('#form-tambah-product .btn-submit').prop('disabled', false);
        } else {
            // Tab lain aktif - disable tombol submit
            $('#form-tambah-product .btn-submit').prop('disabled', true);
        }
    });

    // Handle tab change untuk Form Edit - tombol selalu enabled
    $(document).on('shown.bs.tab', 'a[id^="edit-"][data-toggle="tab"]', function (e) {
        var targetTab = $(e.target).attr('href');
        var productId = targetTab.match(/\d+/); // Extract product ID from href

        // Untuk form edit, tombol submit selalu enabled (tidak ada restriction tab)
        if (productId) {
            $('#form-edit-product-' + productId[0] + ' .btn-submit-edit').prop('disabled', false);
        }
    });

    // Inisialisasi Select2 untuk form edit (harus diinisialisasi saat modal dibuka)
    $('[id^="modal-edit-"]').on('shown.bs.modal', function () {
        $(this).find('.select2-edit').select2({
            dropdownParent: $(this).find('.modal-content')
        });

        // Enable tombol submit untuk form edit (tidak ada restriction seperti form tambah)
        $(this).find('.btn-submit-edit').prop('disabled', false);
    });

    // Validasi sebelum submit form
    $('#form-tambah-product').on('submit', function(e) {
        // Validasi Tab Data Produk
        var productName = $('#form-tambah-product input[name="name"]').val();
        var categoryId = $('#form-tambah-product select[name="category_id"]').val();
        var brandId = $('#form-tambah-product select[name="brand_id"]').val();
        var unit = $('#form-tambah-product input[name="unit"]').val();
        var minStock = $('#form-tambah-product input[name="min_stock"]').val();

        if (!productName || productName.trim() === '') {
            e.preventDefault();
            alert('Nama Produk wajib diisi!');
            $('#data-tab').tab('show');
            $('#form-tambah-product input[name="name"]').focus();
            return false;
        }

        if (!categoryId || categoryId === '') {
            e.preventDefault();
            alert('Kategori wajib dipilih!');
            $('#data-tab').tab('show');
            $('#form-tambah-product select[name="category_id"]').focus();
            return false;
        }

        if (!brandId || brandId === '') {
            e.preventDefault();
            alert('Merek wajib dipilih!');
            $('#data-tab').tab('show');
            $('#form-tambah-product select[name="brand_id"]').focus();
            return false;
        }

        if (!unit || unit.trim() === '') {
            e.preventDefault();
            alert('Satuan Unit wajib diisi!');
            $('#data-tab').tab('show');
            $('#form-tambah-product input[name="unit"]').focus();
            return false;
        }

        if (!minStock || minStock.trim() === '') {
            e.preventDefault();
            alert('Minimal Stok wajib diisi!');
            $('#data-tab').tab('show');
            $('#form-tambah-product input[name="min_stock"]').focus();
            return false;
        }

        // Validasi Tab Stok per Cabang
        var stockCount = $('#stok-container .card').length;

        if (stockCount === 0) {
            e.preventDefault();
            alert('Minimal harus menambahkan 1 stok cabang!');
            $('#stok-tab').tab('show');
            return false;
        }

        // Validasi bahwa setiap stok memiliki cabang yang dipilih
        var stockValid = true;
        $('#stok-container .stock-branch-select').each(function() {
            if (!$(this).val()) {
                stockValid = false;
                return false;
            }
        });

        if (!stockValid) {
            e.preventDefault();
            alert('Silakan pilih cabang untuk semua stok yang ditambahkan!');
            $('#stok-tab').tab('show');
            return false;
        }

        // Validasi Tab Harga per Cabang
        var priceCount = $('#harga-container .card').length;

        if (priceCount === 0) {
            e.preventDefault();
            alert('Minimal harus menambahkan 1 harga cabang!');
            $('#harga-tab').tab('show');
            return false;
        }

        // Validasi bahwa setiap harga memiliki cabang yang dipilih
        var priceValid = true;
        $('#harga-container .price-branch-select').each(function() {
            if (!$(this).val()) {
                priceValid = false;
                return false;
            }
        });

        if (!priceValid) {
            e.preventDefault();
            alert('Silakan pilih cabang untuk semua harga yang ditambahkan!');
            $('#harga-tab').tab('show');
            return false;
        }

        // Validasi: Cabang di stok harus ada di harga, dan sebaliknya
        var stockBranchIds = [];
        var priceBranchIds = [];
        var branchNames = @json($branches->pluck('name', 'id'));

        // Ambil semua branch_id dari stok
        $('#stok-container .stock-branch-select').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                stockBranchIds.push(parseInt(branchId));
            }
        });

        // Ambil semua branch_id dari harga
        $('#harga-container .price-branch-select').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                priceBranchIds.push(parseInt(branchId));
            }
        });

        // Cek cabang yang ada di stok tapi tidak ada di harga
        var missingInPrice = stockBranchIds.filter(function(id) {
            return priceBranchIds.indexOf(id) === -1;
        });

        if (missingInPrice.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInPrice.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Stok Barang tapi tidak ada di Tab Harga Cabang: ' + missingBranchNames + '.\n\nSilakan tambahkan harga untuk cabang tersebut.');
            $('#harga-tab').tab('show');
            return false;
        }

        // Cek cabang yang ada di harga tapi tidak ada di stok
        var missingInStock = priceBranchIds.filter(function(id) {
            return stockBranchIds.indexOf(id) === -1;
        });

        if (missingInStock.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInStock.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Harga Cabang tapi tidak ada di Tab Stok Barang: ' + missingBranchNames + '.\n\nSilakan tambahkan stok untuk cabang tersebut.');
            $('#stok-tab').tab('show');
            return false;
        }

        return true;
    });

    // Handle reset button untuk form tambah
    $('#form-tambah-product .btn-reset').on('click', function(e) {
        // Reset select2 dropdown ke nilai default (kosong)
        $('#form-tambah-product select[name="category_id"]').val('').trigger('change');
        $('#form-tambah-product select[name="brand_id"]').val('').trigger('change');

        // Reset stok dan harga containers
        $('#stok-container').empty();
        $('#harga-container').empty();
        selectedStockBranches = [];
        selectedPriceBranches = [];
        stockCounter = 0;
        priceCounter = 0;
    });

    // Handle reset button untuk form edit
    $('.form-edit-product .btn-reset').on('click', function(e) {
        var form = $(this).closest('form');

        // Reset select2 dropdown ke nilai original dari database
        var categorySelect = form.find('select[name="category_id"]');
        var brandSelect = form.find('select[name="brand_id"]');

        var originalCategoryValue = categorySelect.data('original-value');
        var originalBrandValue = brandSelect.data('original-value');

        categorySelect.val(originalCategoryValue).trigger('change');
        brandSelect.val(originalBrandValue).trigger('change');
    });

    // Fungsi untuk mendapatkan available branches untuk stok
    function getAvailableStockBranches() {
        return branches.filter(function(branch) {
            return !selectedStockBranches.includes(branch.id);
        });
    }

    // Fungsi untuk mendapatkan available branches untuk harga
    function getAvailablePriceBranches() {
        return branches.filter(function(branch) {
            return !selectedPriceBranches.includes(branch.id);
        });
    }

    // Handle Tambah Stok Cabang
    $('#btn-add-stock').on('click', function() {
        var availableBranches = getAvailableStockBranches();

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = stockCounter;
        var stockId = 'stock-' + currentIndex;
        stockCounter++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });

        var html = `
            <div class="card mb-3" id="${stockId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="stocks[${currentIndex}][branch_id]" class="form-control stock-branch-select" data-stock-id="${stockId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Jumlah Stok <span class="text-danger">*</span></label>
                                <input type="number" name="stocks[${currentIndex}][quantity]"
                                    class="form-control" placeholder="0" min="0" value="0" required>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-stock" data-stock-id="${stockId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#stok-container').append(html);
    });

    // Handle perubahan pilihan cabang untuk stok
    $(document).on('change', '.stock-branch-select', function() {
        var selectedBranchId = parseInt($(this).val());
        var stockId = $(this).data('stock-id');

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = selectedStockBranches.indexOf(oldBranchId);
            if (index > -1) {
                selectedStockBranches.splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            selectedStockBranches.push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus stok cabang
    $(document).on('click', '.btn-remove-stock', function() {
        var stockId = $(this).data('stock-id');
        var branchSelect = $('#' + stockId).find('.stock-branch-select');
        var branchId = parseInt(branchSelect.val());

        // Hapus dari array selected branches
        if (branchId) {
            var index = selectedStockBranches.indexOf(branchId);
            if (index > -1) {
                selectedStockBranches.splice(index, 1);
            }
        }

        // Hapus card
        $('#' + stockId).remove();
    });

    // Handle Tambah Harga Cabang
    $('#btn-add-price').on('click', function() {
        var availableBranches = getAvailablePriceBranches();

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = priceCounter;
        var priceId = 'price-' + currentIndex;
        priceCounter++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });


        var html = `
            <div class="card mb-3" id="${priceId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="prices[${currentIndex}][branch_id]" class="form-control price-branch-select" data-price-id="${priceId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Beli <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][purchase_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01" value="0" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Jual <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][selling_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01" value="0" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-price" data-price-id="${priceId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#harga-container').append(html);
    });

    // Handle perubahan pilihan cabang untuk harga
    $(document).on('change', '.price-branch-select', function() {
        var selectedBranchId = parseInt($(this).val());
        var priceId = $(this).data('price-id');

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = selectedPriceBranches.indexOf(oldBranchId);
            if (index > -1) {
                selectedPriceBranches.splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            selectedPriceBranches.push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus harga cabang
    $(document).on('click', '.btn-remove-price', function() {
        var priceId = $(this).data('price-id');
        var branchSelect = $('#' + priceId).find('.price-branch-select');
        var branchId = parseInt(branchSelect.val());

        // Hapus dari array selected branches
        if (branchId) {
            var index = selectedPriceBranches.indexOf(branchId);
            if (index > -1) {
                selectedPriceBranches.splice(index, 1);
            }
        }

        // Hapus card
        $('#' + priceId).remove();
    });

    // ============================================
    // JAVASCRIPT UNTUK FORM EDIT
    // ============================================

    // Track counters dan selected branches untuk setiap produk edit
    var editStockCounters = {};
    var editPriceCounters = {};
    var editSelectedStockBranches = {};
    var editSelectedPriceBranches = {};

    // Initialize counters saat modal edit dibuka
    $('[id^="modal-edit-"]').on('shown.bs.modal', function() {
        var productId = $(this).find('form').data('product-id');

        // Initialize counters berdasarkan jumlah item yang sudah ada
        if (!editStockCounters[productId]) {
            editStockCounters[productId] = $('#stok-container-' + productId + ' .card').length;
        }
        if (!editPriceCounters[productId]) {
            editPriceCounters[productId] = $('#harga-container-' + productId + ' .card').length;
        }

        // Initialize selected branches
        if (!editSelectedStockBranches[productId]) {
            editSelectedStockBranches[productId] = [];
            $('#stok-container-' + productId + ' .stock-branch-select-edit').each(function() {
                var branchId = parseInt($(this).val());
                if (branchId) {
                    editSelectedStockBranches[productId].push(branchId);
                }
            });
        }

        if (!editSelectedPriceBranches[productId]) {
            editSelectedPriceBranches[productId] = [];
            $('#harga-container-' + productId + ' .price-branch-select-edit').each(function() {
                var branchId = parseInt($(this).val());
                if (branchId) {
                    editSelectedPriceBranches[productId].push(branchId);
                }
            });
        }
    });

    // Fungsi untuk mendapatkan available branches untuk stok edit
    function getAvailableStockBranchesEdit(productId) {
        return branches.filter(function(branch) {
            return !editSelectedStockBranches[productId] || !editSelectedStockBranches[productId].includes(branch.id);
        });
    }

    // Fungsi untuk mendapatkan available branches untuk harga edit
    function getAvailablePriceBranchesEdit(productId) {
        return branches.filter(function(branch) {
            return !editSelectedPriceBranches[productId] || !editSelectedPriceBranches[productId].includes(branch.id);
        });
    }

    // Handle Tambah Stok Cabang Edit
    $(document).on('click', '.btn-add-stock-edit', function() {
        var productId = $(this).data('product-id');
        var availableBranches = getAvailableStockBranchesEdit(productId);

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = editStockCounters[productId];
        var stockId = 'stock-edit-' + productId + '-' + currentIndex;
        editStockCounters[productId]++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });

        var html = `
            <div class="card mb-3" id="${stockId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="stocks[${currentIndex}][branch_id]" class="form-control stock-branch-select-edit" data-stock-id="${stockId}" data-product-id="${productId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Jumlah Stok <span class="text-danger">*</span></label>
                                <input type="number" name="stocks[${currentIndex}][quantity]"
                                    class="form-control" placeholder="0" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-stock-edit" data-stock-id="${stockId}" data-product-id="${productId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#stok-container-' + productId).append(html);
    });

    // Handle perubahan pilihan cabang untuk stok edit
    $(document).on('change', '.stock-branch-select-edit', function() {
        var selectedBranchId = parseInt($(this).val());
        var stockId = $(this).data('stock-id');
        var productId = $(this).data('product-id');

        if (!editSelectedStockBranches[productId]) {
            editSelectedStockBranches[productId] = [];
        }

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = editSelectedStockBranches[productId].indexOf(oldBranchId);
            if (index > -1) {
                editSelectedStockBranches[productId].splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            editSelectedStockBranches[productId].push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus stok cabang edit
    $(document).on('click', '.btn-remove-stock-edit', function() {
        var stockId = $(this).data('stock-id');
        var productId = $(this).data('product-id');
        var branchSelect = $('#' + stockId).find('.stock-branch-select-edit');
        var branchId = parseInt(branchSelect.val());

        if (!editSelectedStockBranches[productId]) {
            editSelectedStockBranches[productId] = [];
        }

        // Hapus dari array selected branches
        if (branchId) {
            var index = editSelectedStockBranches[productId].indexOf(branchId);
            if (index > -1) {
                editSelectedStockBranches[productId].splice(index, 1);
            }
        }

        // Hapus card
        $('#' + stockId).remove();
    });

    // Handle Tambah Harga Cabang Edit
    $(document).on('click', '.btn-add-price-edit', function() {
        var productId = $(this).data('product-id');
        var availableBranches = getAvailablePriceBranchesEdit(productId);

        if (availableBranches.length === 0) {
            alert('Semua cabang sudah ditambahkan!');
            return;
        }

        var currentIndex = editPriceCounters[productId];
        var priceId = 'price-edit-' + productId + '-' + currentIndex;
        editPriceCounters[productId]++;

        var branchOptions = '<option value="">Pilih Cabang</option>';
        availableBranches.forEach(function(branch) {
            branchOptions += '<option value="' + branch.id + '">' + branch.name + '</option>';
        });


        var html = `
            <div class="card mb-3" id="${priceId}">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Cabang <span class="text-danger">*</span></label>
                                <select name="prices[${currentIndex}][branch_id]" class="form-control price-branch-select-edit" data-price-id="${priceId}" data-product-id="${productId}" required>
                                    ${branchOptions}
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Beli <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][purchase_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01"  required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Harga Jual <span class="text-danger">*</span></label>
                                <input type="number" name="prices[${currentIndex}][selling_price]"
                                    class="form-control" placeholder="0" min="0" step="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label>&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-block btn-remove-price-edit" data-price-id="${priceId}" data-product-id="${productId}">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#harga-container-' + productId).append(html);
    });

    // Handle perubahan pilihan cabang untuk harga edit
    $(document).on('change', '.price-branch-select-edit', function() {
        var selectedBranchId = parseInt($(this).val());
        var priceId = $(this).data('price-id');
        var productId = $(this).data('product-id');

        if (!editSelectedPriceBranches[productId]) {
            editSelectedPriceBranches[productId] = [];
        }

        // Hapus branch ID lama jika ada
        var oldBranchId = $(this).data('old-branch-id');
        if (oldBranchId) {
            var index = editSelectedPriceBranches[productId].indexOf(oldBranchId);
            if (index > -1) {
                editSelectedPriceBranches[productId].splice(index, 1);
            }
        }

        // Tambah branch ID baru
        if (selectedBranchId) {
            editSelectedPriceBranches[productId].push(selectedBranchId);
            $(this).data('old-branch-id', selectedBranchId);
        }
    });

    // Handle hapus harga cabang edit
    $(document).on('click', '.btn-remove-price-edit', function() {
        var priceId = $(this).data('price-id');
        var productId = $(this).data('product-id');
        var branchSelect = $('#' + priceId).find('.price-branch-select-edit');
        var branchId = parseInt(branchSelect.val());

        if (!editSelectedPriceBranches[productId]) {
            editSelectedPriceBranches[productId] = [];
        }

        // Hapus dari array selected branches
        if (branchId) {
            var index = editSelectedPriceBranches[productId].indexOf(branchId);
            if (index > -1) {
                editSelectedPriceBranches[productId].splice(index, 1);
            }
        }

        // Hapus card
        $('#' + priceId).remove();
    });

    // ============================================
    // SEARCH & FILTER FUNCTIONALITY
    // ============================================

    // Initialize Select2 for filter dropdowns
    $('.select2-filter').select2({
        placeholder: "Pilih...",
        allowClear: true,
        width: '100%'
    });

    // Initialize Select2 for product search with search functionality
    $('.select2-search').select2({
        placeholder: "Cari berdasarkan ID atau Nama Produk...",
        allowClear: true,
        width: '100%'
    });

    // Initialize DataTable
    var table = $('#example1').DataTable();

    // Custom search untuk ID atau Nama Produk berdasarkan select2
    $('#searchProduct').on('change', function() {
        var selectedId = this.value;

        if (selectedId) {
            // Search by ID with leading zeros (00{id})
            var searchTerm = '00' + selectedId;
            table.search(searchTerm).draw();
        } else {
            // Clear search
            table.search('').draw();
        }
    });

    // Filter berdasarkan Kategori
    $('#filterCategory').on('change', function() {
        var selectedCategory = this.value;

        // Column index 2 adalah kolom Kategori (0-based index)
        if (selectedCategory) {
            table.column(2).search('^' + selectedCategory + '$', true, false).draw();
        } else {
            table.column(2).search('').draw();
        }
    });

    // Filter berdasarkan Merek
    $('#filterBrand').on('change', function() {
        var selectedBrand = this.value;

        // Column index 3 adalah kolom Merek (0-based index)
        if (selectedBrand) {
            table.column(3).search('^' + selectedBrand + '$', true, false).draw();
        } else {
            table.column(3).search('').draw();
        }
    });

    // Validasi sebelum submit form edit
    $(document).on('submit', '.form-edit-product', function(e) {
        var form = $(this);
        var productId = form.data('product-id');

        // Validasi: Cabang di stok harus ada di harga, dan sebaliknya
        var stockBranchIds = [];
        var priceBranchIds = [];
        var branchNames = @json($branches->pluck('name', 'id'));

        // Ambil semua branch_id dari stok
        $('#stok-container-' + productId + ' .stock-branch-select-edit').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                stockBranchIds.push(parseInt(branchId));
            }
        });

        // Ambil semua branch_id dari harga
        $('#harga-container-' + productId + ' .price-branch-select-edit').each(function() {
            var branchId = $(this).val();
            if (branchId) {
                priceBranchIds.push(parseInt(branchId));
            }
        });

        // Cek cabang yang ada di stok tapi tidak ada di harga
        var missingInPrice = stockBranchIds.filter(function(id) {
            return priceBranchIds.indexOf(id) === -1;
        });

        if (missingInPrice.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInPrice.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Stok Barang tapi tidak ada di Tab Harga Cabang: ' + missingBranchNames + '.\n\nSilakan tambahkan harga untuk cabang tersebut.');
            $('#harga-tab-edit-' + productId).tab('show');
            return false;
        }

        // Cek cabang yang ada di harga tapi tidak ada di stok
        var missingInStock = priceBranchIds.filter(function(id) {
            return stockBranchIds.indexOf(id) === -1;
        });

        if (missingInStock.length > 0) {
            e.preventDefault();
            var missingBranchNames = missingInStock.map(function(id) {
                return branchNames[id];
            }).join(', ');
            alert('Cabang berikut ada di Tab Harga Cabang tapi tidak ada di Tab Stok Barang: ' + missingBranchNames + '.\n\nSilakan tambahkan stok untuk cabang tersebut.');
            $('#stok-tab-edit-' + productId).tab('show');
            return false;
        }

        return true;
    });

    // Handle custom file input label untuk modal import
    $('#excel_file').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });
});
</script>
@endpush

