@extends('layouts.customer')

@section('title', 'Detail Service')

@push('styles')
<style>
    .detail-card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        margin-bottom: 20px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    .detail-card h5 {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 20px;
        color: #333;
        border-bottom: 2px solid #667eea;
        padding-bottom: 10px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .detail-card h5 i {
        color: #667eea;
    }

    .info-row {
        display: flex;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }

    .info-row:last-child {
        border-bottom: none;
    }

    .info-label {
        font-weight: 600;
        width: 200px;
        color: #666;
        flex-shrink: 0;
    }

    .info-value {
        color: #333;
        flex: 1;
    }

    .status-timeline {
        position: relative;
        padding-left: 40px;
    }

    .status-timeline:before {
        content: '';
        position: absolute;
        left: 15px;
        top: 0;
        bottom: 0;
        width: 3px;
        background: #e0e0e0;
    }

    .timeline-item {
        position: relative;
        margin-bottom: 25px;
        padding-bottom: 10px;
    }

    .timeline-item:last-child {
        margin-bottom: 0;
    }

    .timeline-dot {
        position: absolute;
        left: -32px;
        top: 5px;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        background: white;
        border: 4px solid #667eea;
        z-index: 1;
    }

    .timeline-dot.active {
        background: #667eea;
        box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.2);
        animation: pulse-dot 2s ease-in-out infinite;
    }

    @keyframes pulse-dot {
        0%, 100% { box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.2); }
        50% { box-shadow: 0 0 0 8px rgba(102, 126, 234, 0.1); }
    }

    .timeline-content {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 10px;
        border-left: 3px solid #667eea;
    }

    .timeline-status {
        font-weight: 600;
        color: #667eea;
        font-size: 15px;
        margin-bottom: 5px;
        text-transform: uppercase;
    }

    .timeline-date {
        font-size: 13px;
        color: #999;
        margin-bottom: 5px;
    }

    .timeline-notes {
        font-size: 14px;
        color: #666;
        margin: 5px 0 0 0;
    }

    .timeline-user {
        font-size: 12px;
        color: #999;
        font-style: italic;
    }

    .parts-table {
        width: 100%;
        margin-top: 10px;
    }

    .parts-table th {
        background: #f8f9fa;
        padding: 12px;
        font-weight: 600;
        color: #666;
        border-bottom: 2px solid #e0e0e0;
    }

    .parts-table td {
        padding: 12px;
        border-bottom: 1px solid #f0f0f0;
    }

    .back-btn {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 12px 30px;
        border-radius: 25px;
        font-weight: 500;
        transition: all 0.3s;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        color: white;
        text-decoration: none;
    }

    .cost-summary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 20px;
        border-radius: 10px;
        margin-top: 15px;
    }

    .cost-row {
        display: flex;
        justify-content: space-between;
        padding: 8px 0;
        border-bottom: 1px solid rgba(255,255,255,0.2);
    }

    .cost-row:last-child {
        border-bottom: none;
        font-size: 18px;
        font-weight: 700;
        padding-top: 15px;
        border-top: 2px solid rgba(255,255,255,0.3);
    }

    .current-status-banner {
        background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
        color: white;
        padding: 20px;
        border-radius: 15px;
        margin-bottom: 20px;
        text-align: center;
    }

    .current-status-banner h3 {
        margin: 0 0 10px 0;
        font-size: 24px;
        font-weight: 700;
        text-transform: uppercase;
    }

    .current-status-banner p {
        margin: 0;
        opacity: 0.9;
    }

    @media (max-width: 768px) {
        .info-row {
            flex-direction: column;
        }

        .info-label {
            width: 100%;
            margin-bottom: 5px;
        }
    }
</style>
@endpush

@section('content')
<a href="{{ route('customer.dashboard') }}" class="back-btn">
    <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
</a>

<!-- Current Status Banner -->
<div class="current-status-banner">
    <h3><i class="fas fa-info-circle"></i> {{ $service->status }}</h3>
    <p>Status service saat ini</p>
</div>

<div class="row">
    <!-- Informasi Device -->
    <div class="col-lg-6">
        <div class="detail-card">
            <h5><i class="fas fa-mobile-alt"></i> Informasi Device</h5>
            <div class="info-row">
                <div class="info-label">Nomor Service:</div>
                <div class="info-value"><strong>{{ $service->service_number }}</strong></div>
            </div>
            <div class="info-row">
                <div class="info-label">Tanggal Service:</div>
                <div class="info-value">{{ \Carbon\Carbon::parse($service->service_date)->format('d F Y, H:i') }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Jenis Device:</div>
                <div class="info-value">{{ $service->device_type }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Merk:</div>
                <div class="info-value"><strong>{{ $service->device_brand }}</strong></div>
            </div>
            <div class="info-row">
                <div class="info-label">Model:</div>
                <div class="info-value"><strong>{{ $service->device_model }}</strong></div>
            </div>
            @if($service->imei)
            <div class="info-row">
                <div class="info-label">IMEI / Serial:</div>
                <div class="info-value">{{ $service->imei }}</div>
            </div>
            @endif
            <div class="info-row">
                <div class="info-label">Cabang:</div>
                <div class="info-value">{{ $service->branch->name ?? '-' }}</div>
            </div>
            @if($service->technician)
            <div class="info-row">
                <div class="info-label">Teknisi:</div>
                <div class="info-value">{{ $service->technician->name }}</div>
            </div>
            @endif
            @if($service->priority)
            <div class="info-row">
                <div class="info-label">Prioritas:</div>
                <div class="info-value">
                    <span class="badge badge-{{ $service->priority == 'urgent' ? 'danger' : ($service->priority == 'high' ? 'warning' : 'info') }}">
                        {{ strtoupper($service->priority) }}
                    </span>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- Keluhan & Diagnosa -->
    <div class="col-lg-6">
        <div class="detail-card">
            <h5><i class="fas fa-clipboard-list"></i> Keluhan & Diagnosa</h5>
            <div class="info-row">
                <div class="info-label">Keluhan:</div>
                <div class="info-value">{{ $service->complaint }}</div>
            </div>
            @if($service->diagnosis)
            <div class="info-row">
                <div class="info-label">Diagnosa:</div>
                <div class="info-value">{{ $service->diagnosis }}</div>
            </div>
            @endif
            @if($service->estimated_completion)
            <div class="info-row">
                <div class="info-label">Estimasi Selesai:</div>
                <div class="info-value">{{ \Carbon\Carbon::parse($service->estimated_completion)->format('d F Y, H:i') }}</div>
            </div>
            @endif
            @if($service->completed_at)
            <div class="info-row">
                <div class="info-label">Selesai Pada:</div>
                <div class="info-value">{{ \Carbon\Carbon::parse($service->completed_at)->format('d F Y, H:i') }}</div>
            </div>
            @endif
            @if($service->notes)
            <div class="info-row">
                <div class="info-label">Catatan:</div>
                <div class="info-value">{{ $service->notes }}</div>
            </div>
            @endif
        </div>
    </div>
</div>

<!-- Sparepart yang Digunakan -->
@if($service->serviceDetails && $service->serviceDetails->count() > 0)
<div class="detail-card">
    <h5><i class="fas fa-cogs"></i> Sparepart yang Digunakan</h5>
    <table class="parts-table">
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Sparepart</th>
                <th>Qty</th>
                <th>Harga Satuan</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($service->serviceDetails as $index => $detail)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $detail->product->name ?? '-' }}</td>
                <td>{{ $detail->quantity }}</td>
                <td>Rp {{ number_format($detail->unit_price, 0, ',', '.') }}</td>
                <td>Rp {{ number_format($detail->subtotal, 0, ',', '.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endif

<!-- Biaya Service -->
<div class="detail-card">
    <h5><i class="fas fa-money-bill-wave"></i> Rincian Biaya</h5>
    <div class="cost-summary">
        <div class="cost-row">
            <span>Biaya Service:</span>
            <span>Rp {{ number_format($service->service_fee ?? 0, 0, ',', '.') }}</span>
        </div>
        <div class="cost-row">
            <span>Biaya Sparepart:</span>
            <span>Rp {{ number_format($service->parts_cost ?? 0, 0, ',', '.') }}</span>
        </div>
        <div class="cost-row">
            <span>Total Biaya:</span>
            <span>Rp {{ number_format($service->total_cost ?? 0, 0, ',', '.') }}</span>
        </div>
        <div class="cost-row">
            <span>DP / Dibayar:</span>
            <span>Rp {{ number_format($service->down_payment ?? 0, 0, ',', '.') }}</span>
        </div>
        <div class="cost-row">
            <span>Sisa Pembayaran:</span>
            <span>Rp {{ number_format($service->remaining_payment ?? 0, 0, ',', '.') }}</span>
        </div>
    </div>
</div>

<!-- Timeline Status -->
<div class="detail-card">
    <h5><i class="fas fa-history"></i> Riwayat Status Service</h5>
    <div class="status-timeline">
        @if($service->statusHistories && $service->statusHistories->count() > 0)
            @foreach($service->statusHistories->sortByDesc('created_at') as $index => $history)
            <div class="timeline-item">
                <div class="timeline-dot {{ $index == 0 ? 'active' : '' }}"></div>
                <div class="timeline-content">
                    <div class="timeline-status">{{ $history->status }}</div>
                    <div class="timeline-date">
                        <i class="fas fa-clock"></i> {{ \Carbon\Carbon::parse($history->created_at)->format('d F Y, H:i') }}
                    </div>
                    @if($history->notes)
                    <p class="timeline-notes">{{ $history->notes }}</p>
                    @endif
                    @if($history->user)
                    <div class="timeline-user">
                        <i class="fas fa-user"></i> oleh {{ $history->user->name }}
                    </div>
                    @endif
                </div>
            </div>
            @endforeach
        @else
            <p class="text-muted">Belum ada riwayat status.</p>
        @endif
    </div>
</div>
@endsection
