<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class GiveServicePermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Berikan permission services ke role admin
        $admin = Role::findByName('admin');
        $admin->givePermissionTo([
            'services.index',
            'services.create',
            'services.edit',
            'services.delete'
        ]);

        echo "Permission services berhasil diberikan ke role admin\n";
    }
}
