<?php

namespace App\Http\Controllers\Spatie;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware(['permission:users.index'], ['only' => ['index']]);
        $this->middleware(['permission:users.create'], ['only' => ['save']]);
        $this->middleware(['permission:users.edit'], ['only' => ['update']]);
        $this->middleware(['permission:users.delete'], ['only' => ['delete']]);
    }

    public function index()
    {
        $title = "user";
        $users = User::orderBy('id', 'desc')->get();
        $roles = Role::latest()->get();

        return view('spatie.user', compact('title','users','roles'));
    }

    public function save(Request $request)
    {
        $this->validate($request, [
            'name'      => 'required',
            'email'     => 'required|email|unique:users',
            'password'  => 'required|confirmed'
        ]);

        $user = User::create([
            'name'      => $request->input('name'),
            'email'     => $request->input('email'),
            'password'  => bcrypt($request->input('password'))
        ]);

        //assign role
        $user->assignRole($request->input('role'));

        if($user){
            //redirect dengan pesan sukses
            return redirect()->route('user')->with(['success' => 'Data Berhasil Disimpan!']);
        }else{
            //redirect dengan pesan error
            return redirect()->route('user')->with(['error' => 'Data Gagal Disimpan!']);
        }
    }

    public function update(Request $request, User $user)
    {
        $this->validate($request, [
            'name'      => 'required',
            'email'     => 'required|email|unique:users,email,'.$user->id
        ]);

        $user = User::findOrFail($user->id);

        if($request->input('password') == "") {
            $user->update([
                'name'      => $request->input('name'),
                'email'     => $request->input('email')
            ]);
        } else {
            $user->update([
                'name'      => $request->input('name'),
                'email'     => $request->input('email'),
                'password'  => bcrypt($request->input('password'))
            ]);
        }

        //assign role
        $user->syncRoles($request->input('role'));

        if($user){
            //redirect dengan pesan sukses
            return redirect()->route('user')->with(['success' => 'Data Berhasil Diupdate!']);
        }else{
            //redirect dengan pesan error
            return redirect()->route('user')->with(['error' => 'Data Gagal Diupdate!']);
        }
    }

    public function delete(User $user)
    {
        $user->delete();

        return redirect()->route('user')->with('success', 'Data Berhasil Dihapus');
    }
}
