# Panduan Modul Transaksi - UMI Cell

Dokumentasi lengkap untuk modul transaksi yang telah dibuat pada sistem UMI Cell Inventory Management.

## Daftar Isi
1. [Modul yang Telah Dibuat](#modul-yang-telah-dibuat)
2. [Struktur File](#struktur-file)
3. [Fitur Setiap Modul](#fitur-setiap-modul)
4. [Alur Bisnis](#alur-bisnis)
5. [Setup & Konfigurasi](#setup--konfigurasi)
6. [Testing](#testing)

---

## Modul yang Telah Dibuat

### 1. **Purchases (Pembelian)**
Modul untuk mencatat pembelian barang dari supplier.

**Route:** `/admin/purchase`

**Fitur:**
- ✅ Daftar pembelian dengan filter
- ✅ Form tambah pembelian dengan multiple produk
- ✅ Detail pembelian
- ✅ Edit pembelian (hanya status pending)
- ✅ Hapus pembelian (hanya status pending)
- ✅ Auto-generate nomor pembelian (PO+YYYYMMDD+0001)
- ✅ Auto-update stok saat pembelian completed
- ✅ Tracking pergerakan stok

### 2. **Sales (Penjualan)**
Modul untuk mencatat penjualan barang ke customer.

**Route:** `/admin/sale`

**Fitur:**
- ✅ Daftar penjualan dengan filter
- ✅ Form tambah penjualan dengan cek stok otomatis
- ✅ Detail penjualan
- ✅ Support customer (opsional, bisa umum)
- ✅ Multiple metode pembayaran (Tunai, Transfer, Kredit)
- ✅ Diskon per item dan global
- ✅ Pajak
- ✅ Auto-generate nomor penjualan (SO+YYYYMMDD+0001)
- ✅ Auto-update stok saat penjualan completed
- ✅ Tracking pergerakan stok

### 3. **Stock Movements (Pergerakan Stok)**
Modul untuk melihat histori semua pergerakan stok.

**Route:** `/admin/stock-movement`

**Fitur:**
- ✅ Daftar histori pergerakan stok
- ✅ Filter by produk, cabang, tipe, tanggal
- ✅ Tipe pergerakan: In (masuk), Out (keluar), Adjustment (penyesuaian)
- ✅ Tracking referensi transaksi (Purchase, Sale, Stock Opname)
- ✅ Pagination

### 4. **Stock Opnames**
Modul untuk stock opname (penghitungan fisik stok).

**Route:** `/admin/stock-opname`

**Fitur:**
- ✅ Daftar stock opname
- ✅ Form stock opname dengan auto-load produk per cabang
- ✅ Input stok fisik vs stok sistem
- ✅ Otomatis hitung selisih
- ✅ Auto-adjust stok sesuai hasil opname
- ✅ Auto-generate nomor opname (OP+YYYYMMDD+0001)
- ✅ Tracking pergerakan stok

---

## Struktur File

```
umi-cell/
├── app/
│   └── Http/
│       └── Controllers/
│           └── Transaction/
│               ├── PurchaseController.php
│               ├── SaleController.php
│               ├── StockMovementController.php
│               └── StockOpnameController.php
│
├── resources/
│   └── views/
│       └── transaction/
│           ├── purchase/
│           │   ├── index.blade.php
│           │   ├── create.blade.php
│           │   └── show.blade.php
│           ├── sale/
│           │   ├── index.blade.php
│           │   ├── create.blade.php
│           │   └── show.blade.php
│           ├── stock-movement/
│           │   └── index.blade.php
│           └── stock-opname/
│               ├── index.blade.php
│               ├── create.blade.php
│               └── show.blade.php
│
└── routes/
    └── web.php (updated dengan transaction routes)
```

---

## Fitur Setiap Modul

### A. Purchase (Pembelian)

#### Create Purchase
1. Pilih supplier dan cabang tujuan
2. Pilih produk yang akan dibeli
3. Input quantity dan harga beli
4. Sistem akan:
   - Generate nomor pembelian otomatis
   - Hitung total pembelian
   - Simpan data pembelian dan detail
   - **Tambah stok** ke cabang yang dipilih
   - Catat pergerakan stok (type: in)

#### Business Logic
```php
// Auto-generate Purchase Number
Format: PO + YYYYMMDD + 0001
Contoh: PO202512150001

// Stock Update (Pembelian Completed)
ProductStock::increment('quantity', $purchasedQuantity);

// Stock Movement
Type: 'in'
Reference: Purchase
```

---

### B. Sale (Penjualan)

#### Create Sale
1. **Pilih cabang terlebih dahulu** (penting untuk cek stok)
2. Pilih customer (opsional)
3. Pilih produk - sistem akan otomatis load:
   - Stok tersedia di cabang tersebut
   - Harga jual yang berlaku
4. Input quantity (tidak boleh melebihi stok)
5. Bisa tambah diskon per item
6. Pilih metode pembayaran
7. Bisa tambah diskon global dan pajak
8. Sistem akan:
   - Validasi stok mencukupi
   - Generate nomor penjualan
   - Hitung subtotal, diskon, pajak, total
   - **Kurangi stok** dari cabang
   - Catat profit (harga jual - harga beli)
   - Catat pergerakan stok (type: out)

#### Business Logic
```php
// Auto-generate Sale Number
Format: SO + YYYYMMDD + 0001
Contoh: SO202512150001

// Stock Validation
if (stock < quantity) {
    throw Exception('Stok tidak mencukupi');
}

// Stock Update (Penjualan Completed)
ProductStock::decrement('quantity', $soldQuantity);

// Calculation
Subtotal = Sum(quantity * selling_price - item_discount)
Total = Subtotal - global_discount + tax

// Stock Movement
Type: 'out'
Reference: Sale
```

---

### C. Stock Movement (Pergerakan Stok)

#### View Stock Movements
1. Filter berdasarkan:
   - Produk
   - Cabang
   - Tipe (in/out/adjustment)
   - Range tanggal
2. Lihat histori lengkap dengan:
   - Tanggal & waktu
   - Tipe pergerakan
   - Quantity
   - Referensi transaksi
   - User yang input

#### Stock Movement Types
```
IN         = Stok masuk (dari Purchase)
OUT        = Stok keluar (dari Sale)
ADJUSTMENT = Penyesuaian (dari Stock Opname)
```

---

### D. Stock Opname

#### Create Stock Opname
1. Pilih cabang
2. Klik "Muat Produk" - sistem akan load semua produk yang ada stok di cabang tersebut
3. Untuk setiap produk:
   - Lihat stok sistem
   - Input stok fisik (hasil penghitungan manual)
   - Sistem otomatis hitung selisih
   - Tambah catatan jika perlu
4. Submit - sistem akan:
   - Simpan hasil opname
   - **Adjust stok** sesuai stok fisik
   - Catat pergerakan stok (type: adjustment)

#### Business Logic
```php
// Auto-generate Opname Number
Format: OP + YYYYMMDD + 0001
Contoh: OP202512150001

// Stock Adjustment
difference = physical_stock - system_stock

if (difference != 0) {
    ProductStock::update(['quantity' => physical_stock]);

    StockMovement::create([
        'type' => 'adjustment',
        'quantity' => abs(difference),
        'notes' => 'Stock Opname (difference: +/-XXX)'
    ]);
}
```

---

## Alur Bisnis

### 1. Alur Pembelian
```
1. Supplier mengirim barang
2. Staff gudang input pembelian:
   - Pilih supplier
   - Pilih cabang tujuan
   - Input produk & qty
   - Input harga beli
3. Sistem auto-save dengan status "completed"
4. Stok otomatis bertambah
5. Histori tercatat di Stock Movement
```

### 2. Alur Penjualan
```
1. Customer datang/order
2. Kasir input penjualan:
   - Pilih cabang (untuk cek stok)
   - Pilih customer (opsional)
   - Pilih produk
   - Sistem tampilkan stok & harga
   - Input qty (validasi stok)
   - Pilih metode bayar
3. Sistem cek stok mencukupi
4. Auto-save dengan status "completed"
5. Stok otomatis berkurang
6. Histori tercatat di Stock Movement
```

### 3. Alur Stock Opname
```
1. Staff gudang hitung stok fisik (manual)
2. Input hasil opname:
   - Pilih cabang
   - Load semua produk
   - Input stok fisik hasil hitung
3. Sistem hitung selisih otomatis
4. Submit
5. Stok di-adjust sesuai hasil opname
6. Histori adjustment tercatat
```

---

## Setup & Konfigurasi

### 1. Tambahkan Permission

Jalankan query SQL berikut atau tambah via interface:

```sql
-- Purchases
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('purchases.index', 'web', NOW(), NOW()),
('purchases.create', 'web', NOW(), NOW()),
('purchases.edit', 'web', NOW(), NOW()),
('purchases.delete', 'web', NOW(), NOW()),
('purchases.show', 'web', NOW(), NOW());

-- Sales
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('sales.index', 'web', NOW(), NOW()),
('sales.create', 'web', NOW(), NOW()),
('sales.edit', 'web', NOW(), NOW()),
('sales.delete', 'web', NOW(), NOW()),
('sales.show', 'web', NOW(), NOW());

-- Stock Movements
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('stock-movements.index', 'web', NOW(), NOW());

-- Stock Opnames
INSERT INTO permissions (name, guard_name, created_at, updated_at) VALUES
('stock-opnames.index', 'web', NOW(), NOW()),
('stock-opnames.create', 'web', NOW(), NOW()),
('stock-opnames.edit', 'web', NOW(), NOW()),
('stock-opnames.delete', 'web', NOW(), NOW()),
('stock-opnames.show', 'web', NOW(), NOW());
```

### 2. Assign Permission ke Role

Masuk ke menu **Pengaturan > Roles** dan assign permission sesuai kebutuhan:

#### Super Admin
- Semua permission

#### Manager
- Semua permission transaksi

#### Kasir
- `sales.*` (hanya penjualan)
- `stock-movements.index` (lihat histori)

#### Staff Gudang
- `purchases.*` (pembelian)
- `stock-opnames.*` (stock opname)
- `stock-movements.index` (lihat histori)

### 3. Test Akses

Login dengan user berbeda dan pastikan menu transaksi muncul sesuai permission.

---

## Testing

### Test Purchase
1. Login sebagai user dengan permission `purchases.create`
2. Buka menu **Transaksi > Pembelian**
3. Klik "Tambah Pembelian"
4. Pilih supplier dan cabang
5. Tambah produk dengan qty dan harga
6. Submit
7. Cek:
   - ✅ Data tersimpan di tabel `purchases` dan `purchase_details`
   - ✅ Stok bertambah di `product_stocks`
   - ✅ Histori tercatat di `stock_movements`

### Test Sale
1. Login sebagai user dengan permission `sales.create`
2. Buka menu **Transaksi > Penjualan**
3. Klik "Tambah Penjualan"
4. **Pilih cabang terlebih dahulu**
5. Tambah produk - pastikan stok muncul
6. Coba input qty > stok - harus error
7. Input qty valid, submit
8. Cek:
   - ✅ Data tersimpan di `sales` dan `sale_details`
   - ✅ Stok berkurang di `product_stocks`
   - ✅ Histori tercatat di `stock_movements`

### Test Stock Movement
1. Buka menu **Transaksi > Pergerakan Stok**
2. Cek histori transaksi muncul
3. Test filter by produk, cabang, tipe, tanggal
4. Pastikan data sesuai dengan transaksi yang dibuat

### Test Stock Opname
1. Buka menu **Transaksi > Stock Opname**
2. Klik "Tambah Stock Opname"
3. Pilih cabang, klik "Muat Produk"
4. Ubah beberapa stok fisik
5. Submit
6. Cek:
   - ✅ Data tersimpan di `stock_opnames` dan `stock_opname_details`
   - ✅ Stok ter-adjust di `product_stocks`
   - ✅ Histori adjustment tercatat di `stock_movements`

---

## Fitur Tambahan yang Bisa Dikembangkan

### 1. Laporan
- Laporan penjualan per periode
- Laporan pembelian per supplier
- Laporan profit
- Laporan stok minimum

### 2. Retur
- Retur pembelian
- Retur penjualan

### 3. Transfer Stok
- Transfer antar cabang

### 4. Print/Export
- Print invoice penjualan
- Print PO pembelian
- Export to Excel/PDF

### 5. Dashboard Analytics
- Grafik penjualan
- Top selling products
- Low stock alert
- Stock value

---

## Troubleshooting

### Error: "Call to undefined method"
**Solusi:** Pastikan semua model relationship sudah benar.

### Error: "Permission denied"
**Solusi:** Cek permission sudah ditambahkan dan di-assign ke role yang login.

### Stok tidak update
**Solusi:**
- Cek status transaksi (hanya "completed" yang update stok)
- Cek database transaction berhasil (tidak rollback)

### Menu tidak muncul di sidebar
**Solusi:**
- Cek permission user
- Cek variable `$title` di controller

---

## Kontak & Support

Jika ada pertanyaan atau issue, silakan hubungi tim development.

**Built with Laravel 12 & AdminLTE**

---

**Version:** 1.0
**Last Updated:** 15 Desember 2025
