<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Photo;

class PhotoController extends Controller
{
    public function index()
    {
        $photo = Photo::latest()->paginate(6);
        return response()->json([
            "response" => [
                "status" => 200,
                "message" => "List Data Foto"
            ],
            "data" => $photo
        ], 200);
    }

    public function PhotoHomePage()
    {
        $photo = Photo::latest()->take(2)->get();
        return response()->json([
            "response" => [
                "status" => 200,
                "message" => "List Data Foto Homepage"
            ],
            "data" => $photo
        ], 200);
    }
}
